/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.util;

import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.internal.corext.util.Resources;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;

public class ElementValidator {
    private ElementValidator() {
    }

    public static boolean checkInSync(IAdaptable element, Shell parent, String title) {
        return ElementValidator.checkInSync(new IAdaptable[]{element}, parent, title);
    }

    public static boolean checkInSync(IAdaptable[] elements, Shell parent, String title) {
        return ElementValidator.checkInSync(ElementValidator.getResources(elements), parent, title);
    }

    public static boolean checkValidateEdit(IJavaScriptElement element, Shell parent, String title) {
        return ElementValidator.checkValidateEdit(new IJavaScriptElement[]{element}, parent, title);
    }

    public static boolean checkValidateEdit(IJavaScriptElement[] elements, Shell parent, String title) {
        return ElementValidator.checkValidateEdit(ElementValidator.getResources(elements), parent, title);
    }

    public static boolean check(IJavaScriptElement element, Shell parent, String title, boolean editor) {
        return ElementValidator.check(new IJavaScriptElement[]{element}, parent, title, editor);
    }

    public static boolean check(IJavaScriptElement[] elements, Shell parent, String title, boolean editor) {
        IResource[] resources = ElementValidator.getResources(elements);
        if (!editor && !ElementValidator.checkInSync(resources, parent, title)) {
            return false;
        }
        return ElementValidator.checkValidateEdit(resources, parent, title);
    }

    private static boolean checkInSync(IResource[] resources, Shell parent, String title) {
        IStatus status = Resources.checkInSync(resources);
        if (status.isOK()) {
            return true;
        }
        ErrorDialog.openError((Shell)parent, (String)title, (String)JavaUIMessages.ElementValidator_cannotPerform, (IStatus)status);
        return false;
    }

    private static boolean checkValidateEdit(IResource[] resources, Shell parent, String title) {
        IStatus status = Resources.makeCommittable(resources, (Object)parent);
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)parent, (String)title, (String)JavaUIMessages.ElementValidator_cannotPerform, (IStatus)status);
            return false;
        }
        return true;
    }

    private static IResource[] getResources(IAdaptable[] elements) {
        HashSet<IResource> result = new HashSet<IResource>();
        int i = 0;
        while (i < elements.length) {
            IAdaptable element = elements[i];
            IResource resource = null;
            if (element instanceof IJavaScriptElement) {
                IJavaScriptElement je = (IJavaScriptElement)element;
                IJavaScriptUnit cu = (IJavaScriptUnit)je.getAncestor(5);
                if (cu != null) {
                    je = cu.getPrimary();
                }
                resource = je.getResource();
            } else {
                resource = (IResource)element.getAdapter(IResource.class);
            }
            if (resource != null) {
                result.add(resource);
            }
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }
}

