/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.wst.jsdt.internal.ui.text.java.IJavaReconcilingListener;
import org.eclipse.wst.jsdt.internal.ui.text.java.IProblemRequestorExtension;

public class JavascriptReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private ITextEditor fEditor;
    private WorkingCopyManager fManager;
    private IDocumentProvider fDocumentProvider;
    private IProgressMonitor fProgressMonitor;
    private boolean fNotify = true;
    private IJavaReconcilingListener fJavaReconcilingListener;
    private boolean fIsJavaReconcilingListener;

    public JavascriptReconcilingStrategy(ITextEditor editor) {
        this.fEditor = editor;
        this.fManager = JavaScriptPlugin.getDefault().getWorkingCopyManager();
        this.fDocumentProvider = JavaScriptPlugin.getDefault().getCompilationUnitDocumentProvider();
        this.fIsJavaReconcilingListener = this.fEditor instanceof IJavaReconcilingListener;
        if (this.fIsJavaReconcilingListener) {
            this.fJavaReconcilingListener = (IJavaReconcilingListener)this.fEditor;
        }
    }

    private IProblemRequestorExtension getProblemRequestorExtension() {
        IAnnotationModel model = this.fDocumentProvider.getAnnotationModel((Object)this.fEditor.getEditorInput());
        if (model instanceof IProblemRequestorExtension) {
            return (IProblemRequestorExtension)model;
        }
        return null;
    }

    private void reconcile(final boolean initialReconcile) {
        final JavaScriptUnit[] ast = new JavaScriptUnit[1];
        try {
            final IJavaScriptUnit unit = this.fManager.getWorkingCopy(this.fEditor.getEditorInput(), false);
            if (unit != null) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() {
                        IProblemRequestorExtension extension = JavascriptReconcilingStrategy.this.getProblemRequestorExtension();
                        if (extension != null) {
                            extension.setProgressMonitor(JavascriptReconcilingStrategy.this.fProgressMonitor);
                            extension.setIsActive(true);
                        }
                        try {
                            try {
                                boolean isASTNeeded;
                                boolean bl = isASTNeeded = initialReconcile || JavaScriptPlugin.getDefault().getASTProvider().isActive(unit);
                                if (JavascriptReconcilingStrategy.this.fIsJavaReconcilingListener && isASTNeeded) {
                                    ast[0] = JavaScriptPlugin.getDefault().getASTProvider().getAST(unit, ASTProvider.WAIT_ACTIVE_ONLY, JavascriptReconcilingStrategy.this.fProgressMonitor);
                                }
                            }
                            catch (OperationCanceledException operationCanceledException) {
                                Assert.isTrue((JavascriptReconcilingStrategy.this.fProgressMonitor == null || JavascriptReconcilingStrategy.this.fProgressMonitor.isCanceled() ? 1 : 0) != 0);
                                ast[0] = null;
                                if (extension != null) {
                                    extension.setProgressMonitor(null);
                                    extension.setIsActive(false);
                                }
                            }
                        }
                        finally {
                            if (extension != null) {
                                extension.setProgressMonitor(null);
                                extension.setIsActive(false);
                            }
                        }
                    }

                    public void handleException(Throwable ex) {
                        Status status = new Status(4, "org.eclipse.wst.jsdt.ui", 0, "Error in JSDT Core during reconcile", ex);
                        JavaScriptPlugin.getDefault().getLog().log((IStatus)status);
                    }
                });
            }
        }
        catch (Throwable throwable) {
            try {
                if (this.fIsJavaReconcilingListener) {
                    IProgressMonitor pm = this.fProgressMonitor;
                    if (pm == null) {
                        pm = new NullProgressMonitor();
                    }
                    this.fJavaReconcilingListener.reconciled(ast[0], !this.fNotify, pm);
                }
            }
            finally {
                this.fNotify = true;
            }
            throw throwable;
        }
        try {
            if (this.fIsJavaReconcilingListener) {
                IProgressMonitor pm = this.fProgressMonitor;
                if (pm == null) {
                    pm = new NullProgressMonitor();
                }
                this.fJavaReconcilingListener.reconciled(ast[0], !this.fNotify, pm);
            }
        }
        finally {
            this.fNotify = true;
        }
    }

    public void reconcile(IRegion partition) {
        this.reconcile(false);
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile(false);
    }

    public void setDocument(IDocument document) {
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    public void initialReconcile() {
        this.reconcile(true);
    }

    public void notifyListeners(boolean notify) {
        this.fNotify = notify;
    }

    public void aboutToBeReconciled() {
        if (this.fIsJavaReconcilingListener) {
            this.fJavaReconcilingListener.aboutToBeReconciled();
        }
    }
}

