/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.JavaHeuristicScanner;
import org.eclipse.wst.jsdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaCompletionProposalComputer;
import org.eclipse.wst.jsdt.internal.ui.text.java.LazyGenericTypeProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.LazyJavaTypeCompletionProposal;
import org.eclipse.wst.jsdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.wst.jsdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.wst.jsdt.ui.text.java.JavaContentAssistInvocationContext;

public class JavaTypeCompletionProposalComputer
extends JavaCompletionProposalComputer {
    @Override
    protected CompletionProposalCollector createCollector(JavaContentAssistInvocationContext context) {
        CompletionProposalCollector collector = super.createCollector(context);
        collector.setIgnored(1, true);
        collector.setIgnored(2, true);
        collector.setIgnored(3, true);
        collector.setIgnored(4, true);
        collector.setIgnored(5, true);
        collector.setIgnored(7, true);
        collector.setIgnored(12, true);
        collector.setIgnored(6, true);
        collector.setIgnored(8, true);
        collector.setIgnored(11, true);
        collector.setIgnored(10, true);
        collector.setIgnored(19, true);
        collector.setIgnored(14, true);
        collector.setIgnored(20, true);
        collector.setIgnored(15, true);
        collector.setIgnored(18, true);
        collector.setIgnored(16, true);
        collector.setIgnored(9, false);
        return collector;
    }

    @Override
    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        List types = super.computeCompletionProposals(context, monitor);
        if (context instanceof JavaContentAssistInvocationContext) {
            JavaContentAssistInvocationContext javaContext = (JavaContentAssistInvocationContext)context;
            try {
                IType expectedType;
                if (types.size() > 0 && context.computeIdentifierPrefix().length() == 0 && (expectedType = javaContext.getExpectedType()) != null) {
                    int relevance = Integer.MAX_VALUE;
                    HashSet<String> proposed = new HashSet<String>();
                    for (AbstractJavaCompletionProposal p : types) {
                        IJavaScriptElement element = p.getJavaElement();
                        if (element instanceof IType) {
                            proposed.add(((IType)element).getFullyQualifiedName());
                        }
                        relevance = Math.min(relevance, p.getRelevance());
                    }
                    List history = JavaScriptPlugin.getDefault().getContentAssistHistory().getHistory(expectedType.getFullyQualifiedName()).getTypes();
                    relevance -= history.size() + 1;
                    for (String type : history) {
                        if (proposed.contains(type)) continue;
                        IJavaCompletionProposal proposal = this.createTypeProposal(relevance, type, javaContext);
                        if (proposal != null) {
                            types.add(proposal);
                        }
                        ++relevance;
                    }
                }
            }
            catch (BadLocationException x) {
                JavaScriptPlugin.log(x);
            }
            catch (JavaScriptModelException x) {
                JavaScriptPlugin.log((Throwable)((Object)x));
            }
        }
        return types;
    }

    private IJavaCompletionProposal createTypeProposal(int relevance, String fullyQualifiedType, JavaContentAssistInvocationContext context) throws JavaScriptModelException {
        IType type = context.getCompilationUnit().getJavaScriptProject().findType(fullyQualifiedType);
        if (type == null) {
            return null;
        }
        CompletionProposal proposal = CompletionProposal.create(9, context.getInvocationOffset());
        proposal.setCompletion(fullyQualifiedType.toCharArray());
        proposal.setDeclarationSignature(type.getPackageFragment().getElementName().toCharArray());
        proposal.setFlags(type.getFlags());
        proposal.setRelevance(relevance);
        proposal.setReplaceRange(context.getInvocationOffset(), context.getInvocationOffset());
        proposal.setSignature(Signature.createTypeSignature(fullyQualifiedType, true).toCharArray());
        if (this.shouldProposeGenerics(context.getProject())) {
            return new LazyGenericTypeProposal(proposal, context);
        }
        return new LazyJavaTypeCompletionProposal(proposal, context);
    }

    private final boolean shouldProposeGenerics(IJavaScriptProject project) {
        String sourceVersion = project != null ? project.getOption("org.eclipse.wst.jsdt.core.compiler.source", true) : JavaScriptCore.getOption("org.eclipse.wst.jsdt.core.compiler.source");
        return sourceVersion != null && "1.5".compareTo(sourceVersion) <= 0;
    }

    @Override
    protected int guessContextInformationPosition(ContentAssistInvocationContext context) {
        int contextPosition = context.getInvocationOffset();
        IDocument document = context.getDocument();
        JavaHeuristicScanner scanner = new JavaHeuristicScanner(document);
        int bound = Math.max(-1, contextPosition - 200);
        try {
            int angle;
            int pos = contextPosition - 1;
            while ((angle = scanner.findOpeningPeer(pos, bound, '<', '>')) != -1) {
                int end;
                int off;
                String ident;
                int token = scanner.previousToken(angle - 1, bound);
                if (token == 2000 && JavaHeuristicScanner.isGenericStarter(ident = document.get(off = scanner.getPosition() + 1, (end = angle) - off).trim())) {
                    return angle + 1;
                }
                pos = angle - 1;
            }
        }
        catch (BadLocationException badLocationException) {}
        return super.guessContextInformationPosition(context);
    }
}

