/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;

public class ParentChecker {
    private IResource[] fResources;
    private IJavaScriptElement[] fJavaElements;

    public ParentChecker(IResource[] resources, IJavaScriptElement[] javaElements) {
        Assert.isNotNull((Object)resources);
        Assert.isNotNull((Object)javaElements);
        this.fResources = resources;
        this.fJavaElements = javaElements;
    }

    public boolean haveCommonParent() {
        return this.getCommonParent() != null;
    }

    public Object getCommonParent() {
        if (this.fJavaElements.length == 0 && this.fResources.length == 0) {
            return null;
        }
        if (!this.resourcesHaveCommonParent() || !this.javaElementsHaveCommonParent()) {
            return null;
        }
        if (this.fJavaElements.length == 0) {
            IResource commonResourceParent = this.getCommonResourceParent();
            Assert.isNotNull((Object)commonResourceParent);
            IJavaScriptElement convertedToJava = JavaScriptCore.create(commonResourceParent);
            if (convertedToJava != null && convertedToJava.exists()) {
                return convertedToJava;
            }
            return commonResourceParent;
        }
        if (this.fResources.length == 0) {
            return this.getCommonJavaElementParent();
        }
        IResource commonResourceParent = this.getCommonResourceParent();
        IJavaScriptElement commonJavaElementParent = this.getCommonJavaElementParent();
        Assert.isNotNull((Object)commonJavaElementParent);
        Assert.isNotNull((Object)commonResourceParent);
        IJavaScriptElement convertedToJava = JavaScriptCore.create(commonResourceParent);
        if (convertedToJava == null || !convertedToJava.exists() || !commonJavaElementParent.equals(convertedToJava)) {
            return null;
        }
        return commonJavaElementParent;
    }

    private IJavaScriptElement getCommonJavaElementParent() {
        Assert.isNotNull((Object)this.fJavaElements);
        Assert.isTrue((this.fJavaElements.length > 0 ? 1 : 0) != 0);
        return this.fJavaElements[0].getParent();
    }

    private IResource getCommonResourceParent() {
        Assert.isNotNull((Object)this.fResources);
        Assert.isTrue((this.fResources.length > 0 ? 1 : 0) != 0);
        return this.fResources[0].getParent();
    }

    private boolean javaElementsHaveCommonParent() {
        if (this.fJavaElements.length == 0) {
            return true;
        }
        IJavaScriptElement firstParent = this.fJavaElements[0].getParent();
        Assert.isNotNull((Object)firstParent);
        int i = 1;
        while (i < this.fJavaElements.length) {
            if (!firstParent.equals(this.fJavaElements[i].getParent())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean resourcesHaveCommonParent() {
        if (this.fResources.length == 0) {
            return true;
        }
        IContainer firstParent = this.fResources[0].getParent();
        Assert.isNotNull((Object)firstParent);
        int i = 1;
        while (i < this.fResources.length) {
            if (!firstParent.equals((Object)this.fResources[i].getParent())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public IResource[] getResources() {
        return this.fResources;
    }

    public IJavaScriptElement[] getJavaElements() {
        return this.fJavaElements;
    }

    public void removeElementsWithAncestorsOnList(boolean removeOnlyJavaElements) {
        if (!removeOnlyJavaElements) {
            this.removeResourcesDescendantsOfResources();
            this.removeResourcesDescendantsOfJavaElements();
        }
        this.removeJavaElementsDescendantsOfJavaElements();
    }

    private void removeResourcesDescendantsOfJavaElements() {
        ArrayList<IResource> subResources = new ArrayList<IResource>(3);
        int i = 0;
        while (i < this.fResources.length) {
            IResource subResource = this.fResources[i];
            int j = 0;
            while (j < this.fJavaElements.length) {
                IJavaScriptElement superElements = this.fJavaElements[j];
                if (ParentChecker.isDescendantOf(subResource, superElements)) {
                    subResources.add(subResource);
                }
                ++j;
            }
            ++i;
        }
        this.removeFromSetToDelete(subResources.toArray(new IResource[subResources.size()]));
    }

    private void removeJavaElementsDescendantsOfJavaElements() {
        ArrayList<IJavaScriptElement> subElements = new ArrayList<IJavaScriptElement>(3);
        int i = 0;
        while (i < this.fJavaElements.length) {
            IJavaScriptElement subElement = this.fJavaElements[i];
            int j = 0;
            while (j < this.fJavaElements.length) {
                IJavaScriptElement superElement = this.fJavaElements[j];
                if (ParentChecker.isDescendantOf(subElement, superElement)) {
                    subElements.add(subElement);
                }
                ++j;
            }
            ++i;
        }
        this.removeFromSetToDelete(subElements.toArray(new IJavaScriptElement[subElements.size()]));
    }

    private void removeResourcesDescendantsOfResources() {
        ArrayList<IResource> subResources = new ArrayList<IResource>(3);
        int i = 0;
        while (i < this.fResources.length) {
            IResource subResource = this.fResources[i];
            int j = 0;
            while (j < this.fResources.length) {
                IResource superResource = this.fResources[j];
                if (ParentChecker.isDescendantOf(subResource, superResource)) {
                    subResources.add(subResource);
                }
                ++j;
            }
            ++i;
        }
        this.removeFromSetToDelete(subResources.toArray(new IResource[subResources.size()]));
    }

    public static boolean isDescendantOf(IResource subResource, IJavaScriptElement superElement) {
        IContainer parent = subResource.getParent();
        while (parent != null) {
            IJavaScriptElement el = JavaScriptCore.create((IResource)parent);
            if (el != null && el.exists() && el.equals(superElement)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static boolean isDescendantOf(IJavaScriptElement subElement, IJavaScriptElement superElement) {
        if (subElement.equals(superElement)) {
            return false;
        }
        IJavaScriptElement parent = subElement.getParent();
        while (parent != null) {
            if (parent.equals(superElement)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static boolean isDescendantOf(IResource subResource, IResource superResource) {
        return !subResource.equals((Object)superResource) && superResource.getFullPath().isPrefixOf(subResource.getFullPath());
    }

    private void removeFromSetToDelete(IResource[] resourcesToNotDelete) {
        this.fResources = ReorgUtils.setMinus(this.fResources, resourcesToNotDelete);
    }

    private void removeFromSetToDelete(IJavaScriptElement[] elementsToNotDelete) {
        this.fJavaElements = ReorgUtils.setMinus(this.fJavaElements, elementsToNotDelete);
    }
}

