/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.javadoc;

import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.formatter.IndentManipulation;
import org.eclipse.wst.jsdt.internal.ui.text.html.SingleCharReader;

public class JavaDocCommentReader
extends SingleCharReader {
    private IBuffer fBuffer;
    private int fCurrPos;
    private int fStartPos;
    private int fEndPos;
    private boolean fWasNewLine;

    public JavaDocCommentReader(IBuffer buf, int start, int end) {
        this.fBuffer = buf;
        this.fStartPos = start + 3;
        this.fEndPos = end - 2;
        this.reset();
    }

    public JavaDocCommentReader(IBuffer buf, int end) {
        this.fBuffer = buf;
        this.fStartPos = this.fEndPos = end;
        this.fStartPos = this.rewind();
        if (this.fStartPos >= 0) {
            this.reset();
        } else {
            this.fCurrPos = this.fEndPos;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read() {
        char ch;
        if (this.fCurrPos >= this.fEndPos) return -1;
        if (this.fWasNewLine) {
            do {
                ch = this.fBuffer.getChar(this.fCurrPos++);
            } while (this.fCurrPos < this.fEndPos && Character.isWhitespace(ch));
            if (ch == '*') {
                if (this.fCurrPos >= this.fEndPos) return -1;
                while ((ch = this.fBuffer.getChar(this.fCurrPos++)) == '*') {
                }
            }
        } else {
            ch = this.fBuffer.getChar(this.fCurrPos++);
        }
        this.fWasNewLine = IndentManipulation.isLineDelimiterChar(ch);
        return ch;
    }

    @Override
    public void close() {
        this.fBuffer = null;
    }

    @Override
    public void reset() {
        this.fCurrPos = this.fStartPos;
        this.fWasNewLine = true;
    }

    private int rewind() {
        if (this.fEndPos > 4) {
            char ch;
            do {
                ch = this.fBuffer.getChar(this.fStartPos--);
            } while (this.fStartPos > 4 && Character.isWhitespace(ch));
            if (ch != 'r' && ch != '/') {
                return -1;
            }
            if ((ch = this.fBuffer.getChar(this.fStartPos--)) != 'a' && ch != '*') {
                return -1;
            }
            if (ch == '*') {
                this.fStartPos += 2;
            } else if ((ch = this.fBuffer.getChar(this.fStartPos--)) != 'v') {
                return -1;
            }
            do {
                ch = this.fBuffer.getChar(this.fStartPos--);
            } while (this.fStartPos > 4 && Character.isWhitespace(ch));
            if (this.fStartPos > 4 && ch == '/' && this.fBuffer.getChar(this.fStartPos) == '*') {
                this.fEndPos = this.fStartPos - 1;
                while (this.fStartPos > 2 && (this.fBuffer.getChar(this.fStartPos - 1) != '/' || this.fBuffer.getChar(this.fStartPos) != '*')) {
                    --this.fStartPos;
                }
                if (this.fBuffer.getChar(this.fStartPos - 1) == '/' || this.fBuffer.getChar(this.fStartPos) == '*') {
                    return this.fStartPos;
                }
            }
        }
        return -1;
    }

    public int getOffset() {
        return this.fCurrPos;
    }
}

