/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.htmlcss;

import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelector;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelectorList;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclaration;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleRule;
import org.eclipse.wst.css.core.internal.util.AbstractCssTraverser;
import org.eclipse.wst.css.core.internal.util.CSSStyleDeclarationFactory;
import org.eclipse.wst.html.core.internal.htmlcss.CSSQueryContext;
import org.w3c.dom.Element;
import org.w3c.dom.css.ElementCSSInlineStyle;

public class CSSQueryTraverser
extends AbstractCssTraverser {
    private Element element;
    private String pseudoName;
    private CSSQueryContext context = null;
    ICSSStyleDeclaration decl = null;

    public ICSSStyleDeclaration getDeclaration() {
        try {
            ICSSStyleDeclaration inlineStyle = (ICSSStyleDeclaration)((ElementCSSInlineStyle)((Object)this.element)).getStyle();
            if (inlineStyle != null) {
                if (this.context == null) {
                    this.context = new CSSQueryContext();
                }
                this.context.overrideWithExpand(inlineStyle, 10000);
            }
        }
        catch (ClassCastException classCastException) {}
        if (this.context == null) {
            return null;
        }
        if (this.decl == null) {
            this.decl = CSSStyleDeclarationFactory.getInstance().createStyleDeclaration();
        }
        this.context.applyFull(this.decl);
        return this.decl;
    }

    private void overwriteDeclaration(ICSSStyleDeclaration d, int specificity) {
        if (d == null) {
            return;
        }
        if (this.context == null) {
            this.context = new CSSQueryContext();
        }
        this.context.overrideWithExpand(d, specificity);
    }

    @Override
    protected short postNode(ICSSNode node) {
        return TRAV_CONT;
    }

    @Override
    protected short preNode(ICSSNode node) {
        if (node instanceof ICSSStyleRule) {
            ICSSStyleRule style = (ICSSStyleRule)node;
            ICSSSelectorList list = style.getSelectors();
            int nSelectors = list.getLength();
            int maxSpecificity = -1;
            int iSelector = 0;
            while (iSelector < nSelectors) {
                ICSSSelector selector = list.getSelector(iSelector);
                int specificity = selector.getSpecificity();
                if (maxSpecificity < specificity && selector.match(this.element, this.pseudoName)) {
                    maxSpecificity = specificity;
                }
                ++iSelector;
            }
            if (maxSpecificity >= 0) {
                this.overwriteDeclaration((ICSSStyleDeclaration)style.getStyle(), maxSpecificity);
            }
            return TRAV_PRUNE;
        }
        return TRAV_CONT;
    }

    private void resetContext() {
        this.context = null;
    }

    public void setElement(Element element, String pseudoName) {
        this.element = element;
        this.pseudoName = pseudoName;
        this.resetContext();
    }
}

