/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.formatter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.css.core.internal.provisional.adapters.ICSSModelAdapter;
import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleDeclarationAdapter;
import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleSheetAdapter;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class CSSFormatUtil {
    private static CSSFormatUtil fInstance;

    public List collectCSSNodes(IStructuredModel model, int start, int length) {
        ArrayList<ICSSNode> nodes = new ArrayList<ICSSNode>();
        IndexedRegion startNode = model.getIndexedRegion(start);
        IndexedRegion endNode = model.getIndexedRegion(start + length - 1);
        if (startNode == null || endNode == null) {
            return nodes;
        }
        if (model instanceof ICSSModel && startNode instanceof ICSSNode && endNode instanceof ICSSNode) {
            ICSSNode ca = this.getCommonAncestor((ICSSNode)((Object)startNode), (ICSSNode)((Object)endNode));
            if (ca != null) {
                ICSSNode node = ca.getFirstChild();
                while (node != null && start + length < ((IndexedRegion)((Object)node)).getStartOffset()) {
                    if (start < ((IndexedRegion)((Object)node)).getEndOffset()) {
                        nodes.add(node);
                    }
                    node = node.getNextSibling();
                }
            }
        } else if (model instanceof IDOMModel && startNode instanceof IDOMNode && endNode instanceof IDOMNode) {
            if (startNode instanceof Text) {
                startNode = (IndexedRegion)((Object)((Text)((Object)startNode)).getParentNode());
            }
            if (endNode instanceof Text) {
                endNode = (IndexedRegion)((Object)((Text)((Object)endNode)).getParentNode());
            }
            IDOMNode ca = (IDOMNode)this.getCommonAncestor((Node)((Object)startNode), (Node)((Object)endNode));
            this.findCSS(nodes, ca);
        }
        return nodes;
    }

    private Node getCommonAncestor(Node node1, Node node2) {
        if (node1 == null || node2 == null) {
            return null;
        }
        Node na = node2;
        while (na != null) {
            Node ta = node1;
            while (ta != null) {
                if (ta == na) {
                    return ta;
                }
                ta = ta.getParentNode();
            }
            na = na.getParentNode();
        }
        return null;
    }

    private void findCSS(List cssNodes, IDOMNode node) {
        ICSSModel model;
        ICSSModelAdapter adapter = (ICSSModelAdapter)node.getAdapterFor(IStyleSheetAdapter.class);
        if (adapter != null) {
            model = adapter.getModel();
            if (model != null && model.getStyleSheetType() == "embeddedCSS") {
                cssNodes.add(model.getDocument());
            }
        } else {
            adapter = (ICSSModelAdapter)node.getAdapterFor(IStyleDeclarationAdapter.class);
            if (adapter != null && (model = adapter.getModel()) != null && model.getStyleSheetType() == "inlineCSS") {
                cssNodes.add(model.getDocument());
            }
        }
        IDOMNode child = (IDOMNode)node.getFirstChild();
        while (child != null) {
            this.findCSS(cssNodes, child);
            child = (IDOMNode)child.getNextSibling();
        }
    }

    private ICSSNode getCommonAncestor(ICSSNode nodeA, ICSSNode nodeB) {
        if (nodeA == null || nodeB == null) {
            return null;
        }
        ICSSNode na = nodeA;
        while (na != null) {
            ICSSNode ta = nodeB;
            while (ta != null) {
                if (ta == na) {
                    return ta;
                }
                ta = ta.getParentNode();
            }
            na = na.getParentNode();
        }
        return null;
    }

    public void replaceSource(IStructuredModel model, int offset, int length, String source) {
        if (model == null) {
            return;
        }
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        if (structuredDocument == null) {
            return;
        }
        if (offset >= 0 && length >= 0 && offset + length <= structuredDocument.getLength()) {
            if (structuredDocument.containsReadOnly(offset, length)) {
                return;
            }
            if (source == null) {
                source = new String();
            }
            structuredDocument.replaceText(structuredDocument, offset, length, source);
        }
    }

    public static synchronized CSSFormatUtil getInstance() {
        if (fInstance == null) {
            fInstance = new CSSFormatUtil();
        }
        return fInstance;
    }

    private CSSFormatUtil() {
    }
}

