/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.eclipse.wtp.sse;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.wst.xml.core.internal.catalog.Catalog;
import org.eclipse.wst.xml.core.internal.catalog.CatalogReader;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;

public class PluginPreferences {
    public static final String USER_CATALOG = "userCatalog";
    public static final String RESOLVE_EXTERNAL_URI = "resolveExternalURI";
    private static final Map<String, Properties> CONFIG = new HashMap<String, Properties>();

    public static boolean isExternalUriAllowed(Properties properties) {
        return Boolean.parseBoolean(properties.getProperty(RESOLVE_EXTERNAL_URI, "false"));
    }

    public static void configure(Plugin plugin, AbstractPreferenceInitializer defaultInitializer, Properties properties) {
        defaultInitializer.initializeDefaultPreferences();
        IEclipsePreferences globalPreferences = DefaultScope.INSTANCE.getNode(PluginPreferences.getPluginId(plugin));
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> globalPreferences.put((String)key, (String)value)));
        PluginPreferences.store(plugin, properties);
    }

    public static void store(Plugin plugin, Properties properties) {
        CONFIG.put(PluginPreferences.getPluginId(plugin), properties);
    }

    private static String getPluginId(Plugin plugin) {
        return plugin.getBundle().getSymbolicName();
    }

    public static void configureCatalog(Properties properties, ICatalog defaultCatalogInterface) {
        Objects.requireNonNull(properties, "Property values are missing.");
        Objects.requireNonNull(defaultCatalogInterface, "Default catalog missing.");
        if (!(defaultCatalogInterface instanceof Catalog)) {
            throw new IllegalArgumentException("Internal error: Catalog implementation '" + defaultCatalogInterface.getClass().getCanonicalName() + "' unsupported.");
        }
        Catalog defaultCatalog = (Catalog)defaultCatalogInterface;
        String catalogProperty = properties.getProperty(USER_CATALOG, "");
        if (!catalogProperty.isEmpty()) {
            File catalogFile = new File(catalogProperty);
            try {
                FileInputStream inputStream = new FileInputStream(catalogFile);
                String orgBase = defaultCatalog.getBase();
                defaultCatalog.setBase(catalogFile.toURI().toString());
                CatalogReader.read(defaultCatalog, inputStream);
                defaultCatalog.setBase(orgBase);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("Value of '%s' refers to '%s', which cannot be read.", USER_CATALOG, catalogFile));
            }
        } else {
            defaultCatalog.clear();
        }
    }

    public static void assertNoChanges(Plugin plugin, Properties properties) {
        Objects.requireNonNull(properties, "Property values are missing.");
        String preferenceId = plugin.getBundle().getSymbolicName();
        Properties originalValues = CONFIG.get(preferenceId);
        if (null == originalValues) {
            throw new IllegalArgumentException("No configuration found for " + preferenceId);
        }
        if (!originalValues.equals(properties)) {
            throw new IllegalArgumentException("The Eclipse formatter does not support multiple configurations.");
        }
    }
}

