/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.eclipse.wtp;

import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipsePluginConfig;
import com.diffplug.spotless.extra.eclipse.wtp.sse.CleanupStep;
import com.diffplug.spotless.extra.eclipse.wtp.sse.PluginPreferences;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.json.core.JSONCorePlugin;
import org.eclipse.wst.json.core.cleanup.CleanupProcessorJSON;
import org.eclipse.wst.json.core.format.FormatProcessorJSON;
import org.eclipse.wst.json.core.internal.preferences.JSONCorePreferenceInitializer;
import org.eclipse.wst.sse.core.internal.cleanup.AbstractStructuredCleanupProcessor;
import org.osgi.framework.BundleActivator;

public class EclipseJsonFormatterStepImpl
extends CleanupStep {
    public EclipseJsonFormatterStepImpl(Properties properties) throws Exception {
        super(new CleanupProcessor(), new FrameworkConfig(properties));
        PluginPreferences.assertNoChanges(JSONCorePlugin.getDefault(), properties);
    }

    private static class FrameworkConfig
    extends CleanupStep.FrameworkConfig {
        private final Properties properties;

        FrameworkConfig(Properties properties) {
            this.properties = properties;
        }

        @Override
        public void activatePlugins(SpotlessEclipsePluginConfig config) {
            super.activatePlugins(config);
            config.add((BundleActivator)new JSONCorePlugin());
        }

        public void customize() {
            PluginPreferences.configure(JSONCorePlugin.getDefault(), new JSONCorePreferenceInitializer(), this.properties);
        }
    }

    private static class CleanupProcessor
    extends CleanupProcessorJSON
    implements CleanupStep.ProcessorAccessor {
        private final FormatProcessorJSON formatter = new FormatProcessorJSON();

        CleanupProcessor() {
        }

        @Override
        public String getTypeId() {
            return this.getContentType();
        }

        @Override
        public AbstractStructuredCleanupProcessor get() {
            return this;
        }

        @Override
        public void refreshPreferences() {
            this.refreshCleanupPreferences();
        }

        @Override
        public String cleanupContent(String input) throws IOException, CoreException {
            return this.formatter.formatContent(input);
        }
    }
}

