/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.model;

import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.internal.core.util.Util;

public class JavaCoreUtil {
    private JavaCoreUtil() {
    }

    public static IMethod findMethod(MethodNode methodNode, IType declaringType) {
        try {
            char[] methodName = methodNode.getName().toCharArray();
            String[] paramTypes = GroovyUtils.getParameterTypeSignatures(methodNode, declaringType.isBinary());
            return Util.findMethod(declaringType, methodName, paramTypes, methodNode instanceof ConstructorNode);
        }
        catch (JavaModelException e) {
            Util.log((Throwable)((Object)e));
            return null;
        }
    }

    public static IMethod findMethod(MethodNode methodNode, IJavaElement referenceContext) {
        IType declaringType = JavaCoreUtil.findType(methodNode.getDeclaringClass().getName(), referenceContext);
        return JavaCoreUtil.findMethod(methodNode, declaringType);
    }

    public static IType findType(String fullyQualifiedName, IJavaElement referenceContext) {
        try {
            IJavaProject project = referenceContext.getJavaProject();
            return project.findType(fullyQualifiedName.replace('$', '.'), (IProgressMonitor)null);
        }
        catch (JavaModelException e) {
            Util.log((Throwable)((Object)e));
            return null;
        }
    }
}

