/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.ui.extract;

import org.codehaus.groovy.eclipse.refactoring.core.extract.ExtractGroovyLocalRefactoring;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.TextInputWizardPage;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.VariableNamesProcessor;
import org.eclipse.jdt.internal.ui.util.RowLayouter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ExtractLocalWizard
extends RefactoringWizard {
    static final String DIALOG_SETTING_SECTION = "ExtractLocalWizard";

    public ExtractLocalWizard(ExtractGroovyLocalRefactoring ref) {
        super((Refactoring)ref, 36);
        this.setDefaultPageTitle(RefactoringMessages.ExtractTempWizard_defaultPageTitle);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new ExtractLocalPage(this.getExtractTempRefactoring().guessLocalNames()));
    }

    private ExtractGroovyLocalRefactoring getExtractTempRefactoring() {
        return (ExtractGroovyLocalRefactoring)this.getRefactoring();
    }

    private static class ExtractLocalPage
    extends TextInputWizardPage {
        private static final String REPLACE_ALL = "replaceOccurrences";
        private final boolean fInitialValid;
        private static final String DESCRIPTION = RefactoringMessages.ExtractTempInputPage_enter_name;
        private String[] fTempNameProposals;
        private IDialogSettings fSettings;

        public ExtractLocalPage(String[] tempNameProposals) {
            super(DESCRIPTION, true, tempNameProposals.length == 0 ? "" : tempNameProposals[0]);
            Assert.isNotNull((Object)tempNameProposals);
            this.fTempNameProposals = tempNameProposals;
            this.fInitialValid = tempNameProposals.length > 0;
        }

        public void createControl(Composite parent) {
            this.loadSettings();
            Composite result = new Composite(parent, 0);
            this.setControl((Control)result);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.verticalSpacing = 8;
            result.setLayout((Layout)layout);
            RowLayouter layouter = new RowLayouter(2);
            Label label = new Label(result, 0);
            label.setText(RefactoringMessages.ExtractTempInputPage_variable_name);
            Text text = this.createTextInputField(result);
            text.selectAll();
            text.setLayoutData((Object)new GridData(768));
            ControlContentAssistHelper.createTextContentAssistant((Text)text, (IContentAssistProcessor)new VariableNamesProcessor(this.fTempNameProposals));
            layouter.perform((Control)label, (Control)text, 1);
            this.addReplaceAllCheckbox(result, layouter);
            this.validateTextField(text.getText());
            Dialog.applyDialogFont((Control)result);
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.extract_temp_page_context");
        }

        private void loadSettings() {
            this.fSettings = this.getDialogSettings().getSection(ExtractLocalWizard.DIALOG_SETTING_SECTION);
            if (this.fSettings == null) {
                this.fSettings = this.getDialogSettings().addNewSection(ExtractLocalWizard.DIALOG_SETTING_SECTION);
                this.fSettings.put(REPLACE_ALL, true);
            }
            this.getExtractLocalRefactoring().setReplaceAllOccurrences(this.fSettings.getBoolean(REPLACE_ALL));
        }

        private void addReplaceAllCheckbox(Composite result, RowLayouter layouter) {
            String title = RefactoringMessages.ExtractTempInputPage_replace_all;
            boolean defaultValue = this.getExtractLocalRefactoring().isReplaceAllOccurrences();
            final Button checkBox = ExtractLocalPage.createCheckbox(result, title, defaultValue, layouter);
            this.getExtractLocalRefactoring().setReplaceAllOccurrences(checkBox.getSelection());
            checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    fSettings.put(ExtractLocalPage.REPLACE_ALL, checkBox.getSelection());
                    this.getExtractLocalRefactoring().setReplaceAllOccurrences(checkBox.getSelection());
                }
            });
        }

        protected void textModified(String text) {
            this.getExtractLocalRefactoring().setLocalName(text);
            super.textModified(text);
        }

        protected RefactoringStatus validateTextField(String text) {
            return this.getExtractLocalRefactoring().checkLocalNameOnChange(text);
        }

        private ExtractGroovyLocalRefactoring getExtractLocalRefactoring() {
            return (ExtractGroovyLocalRefactoring)this.getRefactoring();
        }

        private static Button createCheckbox(Composite parent, String title, boolean value, RowLayouter layouter) {
            Button checkBox = new Button(parent, 32);
            checkBox.setText(title);
            checkBox.setSelection(value);
            layouter.perform((Control)checkBox);
            return checkBox;
        }

        protected boolean isInitialInputValid() {
            return this.fInitialValid;
        }
    }
}

