/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.extract;

import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.ASTFragmentKind;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.FragmentVisitor;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.IASTFragment;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.MethodCallFragment;
import org.codehaus.groovy.eclipse.refactoring.core.extract.StaticExpressionChecker;

public class StaticFragmentChecker
extends FragmentVisitor {
    private boolean maybeStatic = true;
    private boolean previousWasClassExpression = false;
    private StaticExpressionChecker expressionChecker;

    public boolean mayNotBeStatic(IASTFragment fragment) {
        this.expressionChecker = new StaticExpressionChecker();
        fragment.accept((FragmentVisitor)this);
        return this.maybeStatic;
    }

    public boolean previsit(IASTFragment fragment) {
        if (fragment.kind() == ASTFragmentKind.METHOD_CALL && !this.previousWasClassExpression) {
            this.maybeStatic = false;
            return false;
        }
        Expression node = fragment.getAssociatedExpression();
        if (node != null) {
            this.maybeStatic = this.expressionChecker.doVisit(node);
        }
        this.previousWasClassExpression = node instanceof ClassExpression;
        return this.maybeStatic;
    }

    public boolean visit(MethodCallFragment fragment) {
        Expression node = fragment.getArguments();
        if (node != null) {
            this.maybeStatic = this.expressionChecker.doVisit(node);
        }
        return this.maybeStatic;
    }
}

