/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.tools;

import groovy.lang.Tuple;
import groovy.lang.Tuple2;
import java.util.function.Function;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.Parameter;

public class ParameterUtils {
    public static boolean parametersEqual(Parameter[] a, Parameter[] b) {
        return ParameterUtils.parametersEqual(a, b, false);
    }

    public static boolean parametersEqualWithWrapperType(Parameter[] a, Parameter[] b) {
        return ParameterUtils.parametersEqual(a, b, true);
    }

    public static boolean parametersCompatible(Parameter[] source, Parameter[] target) {
        return ParameterUtils.parametersMatch(source, target, t -> ClassHelper.getWrapper((ClassNode)t.getV2()).getTypeClass().isAssignableFrom(ClassHelper.getWrapper((ClassNode)t.getV1()).getTypeClass()));
    }

    private static boolean parametersEqual(Parameter[] a, Parameter[] b, boolean wrapType) {
        return ParameterUtils.parametersMatch(a, b, t -> {
            ClassNode v1 = (ClassNode)t.getV1();
            ClassNode v2 = (ClassNode)t.getV2();
            if (wrapType) {
                v1 = ClassHelper.getWrapper(v1);
                v2 = ClassHelper.getWrapper(v2);
            }
            return v1.equals(v2);
        });
    }

    private static boolean parametersMatch(Parameter[] a, Parameter[] b, Function<Tuple2<ClassNode, ClassNode>, Boolean> typeChecker) {
        if (a.length == b.length) {
            boolean answer = true;
            for (int i = 0; i < a.length; ++i) {
                ClassNode bType;
                ClassNode aType = a[i].getType();
                if (typeChecker.apply(Tuple.tuple(aType, bType = b[i].getType())).booleanValue()) continue;
                answer = false;
                break;
            }
            return answer;
        }
        return false;
    }
}

