/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.parser;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.SourceUnit;

public abstract class AbstractParser {
    private static final Logger LOGGER = Logger.getLogger(AbstractParser.class.getName());

    public ModuleNode parse(File file) {
        if (null == file || !file.exists()) {
            throw new IllegalArgumentException(file + " does not exist.");
        }
        CompilerConfiguration configuration = this.getCompilerConfiguration();
        SourceUnit sourceUnit = new SourceUnit(file, configuration, AccessController.doPrivileged(new PrivilegedAction<GroovyClassLoader>(){

            @Override
            public GroovyClassLoader run() {
                return new GroovyClassLoader();
            }
        }), new ErrorCollector(configuration));
        return this.parse(sourceUnit);
    }

    public ModuleNode parse(String name, String text) {
        if (null == name) {
            throw new IllegalArgumentException("name should not be null");
        }
        if (null == text) {
            throw new IllegalArgumentException("text should not be null");
        }
        CompilerConfiguration configuration = this.getCompilerConfiguration();
        SourceUnit sourceUnit = new SourceUnit(name, text, configuration, AccessController.doPrivileged(new PrivilegedAction<GroovyClassLoader>(){

            @Override
            public GroovyClassLoader run() {
                return new GroovyClassLoader();
            }
        }), new ErrorCollector(configuration));
        return this.parse(sourceUnit);
    }

    public ModuleNode parse(SourceUnit sourceUnit) {
        try {
            sourceUnit.parse();
            sourceUnit.completePhase();
            sourceUnit.nextPhase();
            sourceUnit.convert();
            return sourceUnit.getAST();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to parse " + sourceUnit.getName(), e);
            return null;
        }
    }

    protected abstract CompilerConfiguration getCompilerConfiguration();
}

