/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.eclipse.cdt;

import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipseConfig;
import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipseFramework;
import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipsePluginConfig;
import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipseServiceConfig;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ToolFactory;
import org.eclipse.cdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.osgi.framework.BundleActivator;

public class EclipseCdtFormatterStepImpl {
    private final CodeFormatter codeFormatter;

    public EclipseCdtFormatterStepImpl(Properties settings) throws Exception {
        SpotlessEclipseFramework.setup((SpotlessEclipseConfig)new FrameworkConfig());
        Stream stream = settings.entrySet().stream();
        Map<String, String> settingsMap = stream.collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue())));
        this.codeFormatter = ToolFactory.createDefaultCodeFormatter(settingsMap);
    }

    public String format(String raw) throws Exception {
        TextEdit edit = this.codeFormatter.format(0, raw, 0, raw.length(), 0, "\n");
        if (edit == null) {
            throw new IllegalArgumentException("Invalid C/C++ syntax for formatting.");
        }
        Document doc = new Document(raw);
        edit.apply((IDocument)doc);
        return doc.get();
    }

    private static class FrameworkConfig
    implements SpotlessEclipseConfig {
        private FrameworkConfig() {
        }

        public void registerServices(SpotlessEclipseServiceConfig config) {
            config.applyDefault();
            config.useSlf4J(EclipseCdtFormatterStepImpl.class.getPackage().getName());
        }

        public void activatePlugins(SpotlessEclipsePluginConfig config) {
            config.applyDefault();
            config.add((BundleActivator)new CCorePlugin());
        }
    }
}

