/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.eclipse.base.osgi;

import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipseServiceConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Optional;
import org.eclipse.osgi.internal.framework.DTOBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.dto.ServiceReferenceDTO;

public class ServiceCollection
implements SpotlessEclipseServiceConfig {
    private final Map<String, ServiceReference<?>> className2Service = new HashMap();
    private final Bundle systemBundle;
    private final Map<String, String> properties;

    ServiceCollection(Bundle systemBundle, Map<String, String> properties) {
        this.systemBundle = systemBundle;
        this.properties = properties;
    }

    @Override
    public void set(String key, String value) {
        this.properties.put(key, value);
    }

    @Override
    public <S> void add(Class<S> interfaceClass, S service) throws ServiceException {
        String className = interfaceClass.getName();
        if (null != this.className2Service.put(interfaceClass.getName(), new FrameworkServiceReference(className, service))) {
            throw new ServiceException(String.format("Service '%s' is already registered.", interfaceClass.getName()), 2);
        }
    }

    Filter createFilter(String filterDescr) {
        Optional<String> serviceClassName = this.className2Service.keySet().stream().filter(serviceClazzName -> filterDescr.contains((CharSequence)serviceClazzName)).findFirst();
        return new ClassNameBasedFilter(serviceClassName);
    }

    ServiceReference<?>[] getReferences(String interfaceClassName) {
        ServiceReference[] serviceReferenceArray;
        if (null == interfaceClassName) {
            Collection<ServiceReference<?>> allServices = this.className2Service.values();
            return allServices.toArray(new ServiceReference[allServices.size()]);
        }
        ServiceReference<?> singleService = this.className2Service.get(interfaceClassName);
        if (null == singleService) {
            serviceReferenceArray = null;
        } else {
            ServiceReference[] serviceReferenceArray2 = new ServiceReference[1];
            serviceReferenceArray = serviceReferenceArray2;
            serviceReferenceArray2[0] = singleService;
        }
        return serviceReferenceArray;
    }

    <S> S getService(ServiceReference<S> reference) {
        if (this.systemBundle == reference.getBundle()) {
            return (S)((FrameworkServiceReference)reference).getService();
        }
        return null;
    }

    private class ClassNameBasedFilter
    implements Filter {
        private static final String NO_MATCH_CLASS_NAME = "";
        private final String className;

        private ClassNameBasedFilter(Optional<String> className) {
            this.className = className.orElse(NO_MATCH_CLASS_NAME);
        }

        public boolean match(ServiceReference<?> reference) {
            return reference.isAssignableTo(ServiceCollection.this.systemBundle, this.className);
        }

        @Deprecated
        public boolean match(Dictionary<String, ?> dictionary) {
            throw new UnsupportedOperationException("Dictionary based service look-up is not supported.");
        }

        @Deprecated
        public boolean matchCase(Dictionary<String, ?> dictionary) {
            throw new UnsupportedOperationException("Dictionary based service look-up is not supported.");
        }

        @Deprecated
        public boolean matches(Map<String, ?> map) {
            throw new UnsupportedOperationException("Capability based service look-up is not supported.");
        }

        public String toString() {
            return this.className;
        }
    }

    private class FrameworkServiceReference<S>
    implements ServiceReference<S> {
        private final String className;
        private final S service;

        private FrameworkServiceReference(String className, S service) {
            this.className = className;
            this.service = service;
        }

        private S getService() {
            return this.service;
        }

        public Object getProperty(String key) {
            return ServiceCollection.this.properties.get(key);
        }

        public String[] getPropertyKeys() {
            return ServiceCollection.this.properties.keySet().toArray(new String[ServiceCollection.this.properties.size()]);
        }

        public Bundle getBundle() {
            return ServiceCollection.this.systemBundle;
        }

        public Bundle[] getUsingBundles() {
            return new Bundle[]{ServiceCollection.this.systemBundle};
        }

        public boolean isAssignableTo(Bundle bundle, String className) {
            return this.className.equals(className);
        }

        @SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"})
        public int compareTo(Object reference) {
            return this == reference ? 0 : 1;
        }

        public Dictionary<String, Object> getProperties() {
            return new Hashtable<String, Object>(ServiceCollection.this.properties);
        }

        public <A> A adapt(Class<A> type) {
            if (ServiceReferenceDTO.class.equals(type)) {
                return (A)DTOBuilder.newServiceReferenceDTO((ServiceReference)this);
            }
            return null;
        }
    }
}

