/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.eclipse.base.runtime;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class PluginRegistrar {
    private static final String PLUGIN_XML = "plugin.xml";
    private static final String PLUGIN_PROPERTIES = "plugin.properties";
    private final Bundle bundle;

    public static BundleException register(Bundle bundle) {
        PluginRegistrar registrar = new PluginRegistrar(bundle);
        try {
            registrar.register();
        }
        catch (BundleException e) {
            return e;
        }
        return null;
    }

    private PluginRegistrar(Bundle bundle) {
        this.bundle = bundle;
    }

    private void register() throws BundleException {
        IExtensionRegistry reg = RegistryFactory.getRegistry();
        Object registryUser = ((ExtensionRegistry)reg).getTemporaryUserToken();
        if (!reg.addContribution(this.getStreamForEntry(PLUGIN_XML), this.createContributor(), false, null, this.getPluginProperties(), registryUser)) {
            throw new BundleException("Could not add plugin: " + this.bundle.getSymbolicName(), 12);
        }
    }

    private IContributor createContributor() {
        return new RegistryContributor(Long.toString(this.bundle.getBundleId()), this.bundle.getSymbolicName(), null, null);
    }

    private ResourceBundle getPluginProperties() throws BundleException {
        InputStream is = this.entryExists(PLUGIN_PROPERTIES) ? this.getStreamForEntry(PLUGIN_PROPERTIES) : new ByteArrayInputStream(new byte[0]);
        try {
            return new PropertyResourceBundle(is);
        }
        catch (IOException e) {
            throw new BundleException(String.format("Bund resource '%s' is not encoded with ISO-8859-1.", PLUGIN_PROPERTIES), 3, (Throwable)e);
        }
    }

    private InputStream getStreamForEntry(String path) throws BundleException {
        try {
            return this.getEntry(path).openStream();
        }
        catch (IOException e) {
            throw new BundleException(String.format("Cannot access mandatory resource '%s'.", path), 3, (Throwable)e);
        }
    }

    private URL getEntry(String path) throws BundleException {
        URL url = this.bundle.getEntry(path);
        if (null == url) {
            throw new BundleException(String.format("Cannot find mandatory resource '%s'.", path), 3);
        }
        return url;
    }

    private boolean entryExists(String path) {
        return null != this.bundle.getEntry(path);
    }
}

