/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.eclipse.base.osgi;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Manifest;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.eclipse.osgi.storage.bundlefile.DirBundleFile;
import org.eclipse.osgi.storage.bundlefile.ZipBundleFile;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;

class ResourceAccessor {
    private final String fatJarResourcePath;
    private final BundleFile bundleFile;

    ResourceAccessor() throws BundleException {
        this(ResourceAccessor.class);
    }

    ResourceAccessor(Class<?> clazz) throws BundleException {
        String bundleObjPath = clazz.getName();
        this.fatJarResourcePath = bundleObjPath.substring(0, bundleObjPath.lastIndexOf(46));
        try {
            this.bundleFile = ResourceAccessor.getBundlFile(clazz);
        }
        catch (BundleException e) {
            throw new BundleException(String.format("Failed to locate resources for bunlde '%s'.", clazz.getName()), (Throwable)e);
        }
    }

    private static BundleFile getBundlFile(Class<?> clazz) throws BundleException {
        URI objUri = ResourceAccessor.getBundleUri(clazz);
        File jarOrDirectory = new File(objUri.getPath());
        if (!jarOrDirectory.exists() || !jarOrDirectory.canRead()) {
            throw new BundleException(String.format("Path '%s' for '%s' is not accessible exist on local file system.", objUri, clazz.getName()), 11);
        }
        try {
            return jarOrDirectory.isDirectory() ? new DirBundleFile(jarOrDirectory, false) : new ZipBundleFile(jarOrDirectory, null, null, null);
        }
        catch (IOException e) {
            throw new BundleException(String.format("Cannot access bundle at '%s'.", jarOrDirectory), 11, (Throwable)e);
        }
    }

    private static URI getBundleUri(Class<?> clazz) throws BundleException {
        URL objUrl = clazz.getProtectionDomain().getCodeSource().getLocation();
        try {
            return objUrl.toURI();
        }
        catch (URISyntaxException e) {
            throw new BundleException(String.format("Path '%s' for '%s' is invalid.", objUrl, clazz.getName()), 11, (Throwable)e);
        }
    }

    String getManifestName() throws BundleException {
        URL manifestUrl = this.getEntry("META-INF/MANIFEST.MF");
        if (null != manifestUrl) {
            try {
                Manifest manifest = new Manifest(manifestUrl.openStream());
                String headerValue = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
                if (null == headerValue) {
                    throw new BundleException(String.format("Symbolic values not found in '%s'.", manifestUrl), 3);
                }
                ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)headerValue);
                if (null == elements) {
                    throw new BundleException(String.format("Symbolic name not found '%s'. Value is '%s'.", manifestUrl, headerValue), 3);
                }
                return elements[0].getValueComponents()[0];
            }
            catch (IOException e) {
                throw new BundleException(String.format("Failed to parse Manifest '%s' in '%s'.", manifestUrl, this.bundleFile.toString()), 3, (Throwable)e);
            }
        }
        throw new BundleException(String.format("'%s' in '%s' not found. Tried also fat JAR location '%s'.", "META-INF/MANIFEST.MF", this.bundleFile.toString(), this.fatJarResourcePath), 3);
    }

    URL getEntry(String path) {
        BundleEntry entry = this.bundleFile.getEntry(this.getFatJarPath(path));
        if (null == entry) {
            entry = this.bundleFile.getEntry(path);
        }
        return null == entry ? null : entry.getLocalURL();
    }

    Enumeration<String> getEntries(String path) {
        Enumeration entries = this.bundleFile.getEntryPaths(this.getFatJarPath(path));
        if (null == entries) {
            entries = this.bundleFile.getEntryPaths(path);
        }
        return entries;
    }

    private String getFatJarPath(String path) {
        return this.fatJarResourcePath + "/" + path;
    }
}

