/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.p2;

import com.diffplug.gradle.FileMisc;
import com.diffplug.gradle.p2.AsMavenGroup;
import com.diffplug.gradle.p2.MavenRepoBuilder;
import com.diffplug.gradle.p2.P2AntRunner;
import com.diffplug.gradle.p2.P2Model;
import com.diffplug.gradle.p2.Repo2Runnable;
import java.io.File;
import java.util.Objects;
import org.gradle.api.Project;

class AsMavenGroupImpl {
    final Project project;
    final File p2asmaven;
    final AsMavenGroup def;
    static final String SUBDIR_P2 = "p2";
    static final String SUBDIR_P2_RUNNABLE = "p2runnable";
    static final String SUBDIR_MAVEN = "maven";
    static final int GOOMPH_VERSION = 1;

    public AsMavenGroupImpl(Project project, File p2asmaven, AsMavenGroup group) {
        this.project = Objects.requireNonNull(project);
        this.p2asmaven = Objects.requireNonNull(p2asmaven);
        this.def = Objects.requireNonNull(group);
    }

    File dirP2() {
        return new File(this.p2asmaven, "p2/" + this.def.group);
    }

    File dirP2Runnable() {
        return new File(this.p2asmaven, "p2runnable/" + this.def.group);
    }

    File dirMavenRoot() {
        return new File(this.p2asmaven, SUBDIR_MAVEN);
    }

    File dirMavenGroup() {
        return new File(this.dirMavenRoot(), this.def.group);
    }

    File tokenFile() {
        return new File(this.p2asmaven, "token-" + this.def.group);
    }

    private P2AntRunner getApp() {
        P2Model cached = new P2Model();
        cached.addArtifactRepoBundlePool();
        cached.copyFrom(this.def.model);
        P2AntRunner app = cached.mirrorApp(this.dirP2());
        this.def.antModifier.execute((Object)app);
        return app;
    }

    public void run() throws Exception {
        Objects.requireNonNull(this.def.group, "Must set mavengroup");
        String state = this.state();
        if (FileMisc.hasTokenFile(this.tokenFile(), state)) {
            this.project.getLogger().debug("p2AsMaven " + this.def.group + " is satisfied");
            return;
        }
        this.project.getLogger().lifecycle("p2AsMaven " + this.def.group + " is dirty.");
        FileMisc.cleanDir(this.dirP2());
        FileMisc.cleanDir(this.dirP2Runnable());
        FileMisc.cleanDir(this.dirMavenGroup());
        this.project.getLogger().lifecycle("Initalizing maven group " + this.def.group + " from p2");
        this.project.getLogger().lifecycle("Only needs to be done once, future builds will be much faster");
        this.project.getLogger().lifecycle("p2AsMaven " + this.def.group + " installing from p2");
        this.getApp().runUsingBootstrapper(this.project);
        if (this.def.repo2runnable) {
            this.project.getLogger().lifecycle("p2AsMaven " + this.def.group + " creating runnable repo");
            Repo2Runnable app = new Repo2Runnable();
            app.source(this.dirP2());
            app.destination(this.dirP2Runnable());
            app.runUsingBootstrapper(this.project);
        }
        this.project.getLogger().lifecycle("p2AsMaven " + this.def.group + " creating maven repo");
        try (MavenRepoBuilder maven = new MavenRepoBuilder(this.dirMavenRoot());){
            for (File plugin : FileMisc.list(new File(this.dirP2(), "plugins"))) {
                if (!plugin.isFile() || !plugin.getName().endsWith(".jar")) continue;
                maven.install(this.def.group, plugin);
            }
        }
        FileMisc.writeTokenFile(this.tokenFile(), state);
        this.project.getLogger().lifecycle("p2AsMaven " + this.def.group + " is complete.");
    }

    private String state() {
        return "mirrorApp: " + this.getApp().completeState() + "\nmavenGroup: " + this.def.group + "\ngoomph:" + 1 + "\nrepo2runnable:" + this.def.repo2runnable;
    }
}

