/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.osgi;

import com.diffplug.gradle.FileMisc;
import com.diffplug.gradle.SerializableMisc;
import com.diffplug.gradle.osgi.OsgiExecImp;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public interface OsgiExecable
extends Serializable,
Runnable {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends OsgiExecable> T exec(BundleContext context, T input) throws Exception {
        Bundle bundle = OsgiExecImp.loadBundle(context);
        bundle.start();
        Class clazz = bundle.loadClass(OsgiExecImp.class.getName());
        Method execInternal = clazz.getMethod("execInternal", File.class);
        File tempFile = File.createTempFile("OsgiExec", ".temp");
        try {
            SerializableMisc.write(tempFile, input);
            execInternal.setAccessible(true);
            execInternal.invoke(null, tempFile);
            OsgiExecable osgiExecable = (OsgiExecable)SerializableMisc.read(tempFile);
            return (T)osgiExecable;
        }
        finally {
            FileMisc.forceDelete(tempFile);
        }
    }

    public static abstract class ReflectionClient<Host extends ReflectionHost>
    implements Runnable {
        protected final Host host;

        protected ReflectionClient(Host host) {
            this.host = (ReflectionHost)Objects.requireNonNull(host);
        }
    }

    public static abstract class ReflectionHost
    implements OsgiExecable {
        private final String delegate;

        protected ReflectionHost(String delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        @Override
        public void run() {
            try {
                Bundle bundle = FrameworkUtil.getBundle(OsgiExecable.class);
                Class clazz = bundle.loadClass(this.delegate);
                Constructor<?>[] constructors = clazz.getDeclaredConstructors();
                if (constructors.length != 1) {
                    throw new IllegalArgumentException(this.delegate + " must have only one constructor, this had " + constructors.length);
                }
                if (constructors[0].getParameterCount() != 1) {
                    throw new IllegalArgumentException(this.delegate + "'s constructor must take one argument, this took " + constructors[0].getParameterCount());
                }
                constructors[0].setAccessible(true);
                ReflectionClient client = (ReflectionClient)constructors[0].newInstance(this);
                client.run();
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

