/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.oomph;

import com.diffplug.common.collect.ImmutableList;
import com.diffplug.gradle.oomph.InstalledJre;
import com.diffplug.gradle.oomph.InstalledJreAdder;
import com.diffplug.gradle.oomph.OomphConvention;
import com.diffplug.gradle.oomph.OomphIdeExtension;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;

public class ConventionJdt
extends OomphConvention {
    static final String JDT_CORE_PREFS = ".metadata/.plugins/org.eclipse.core.runtime/.settings/org.eclipse.jdt.core.prefs";
    final Set<InstalledJre> installedJres = new HashSet<InstalledJre>();

    ConventionJdt(OomphIdeExtension extension) {
        super(extension);
        this.requireIUs("org.eclipse.platform.ide", "org.eclipse.jdt.feature.group", "org.eclipse.ui.views.log");
        this.setPerspectiveOver("org.eclipse.jdt.ui.JavaPerspective", "org.eclipse.ui.resourcePerspective");
    }

    public void installedJre(Action<InstalledJre> action) {
        InstalledJre instance = new InstalledJre();
        action.execute((Object)instance);
        this.installedJres.add(instance);
    }

    public void compilerComplianceLevel(String compilerComplianceLevel) {
        ImmutableList JDT_COMPLIANCE_PROPS = ImmutableList.of((Object)"org.eclipse.jdt.core.compiler.codegen.targetPlatform", (Object)"org.eclipse.jdt.core.compiler.compliance", (Object)"org.eclipse.jdt.core.compiler.source");
        this.extension.workspaceProp(JDT_CORE_PREFS, (Action<Map<String, String>>)((Action)arg_0 -> ConventionJdt.lambda$compilerComplianceLevel$63((List)JDT_COMPLIANCE_PROPS, compilerComplianceLevel, arg_0)));
    }

    public void classpathVariable(String name, String value) {
        String JDT_CLASSPATH_VAR_FMT = "org.eclipse.jdt.core.classpathVariable.%s";
        this.extension.workspaceProp(JDT_CORE_PREFS, (Action<Map<String, String>>)((Action)props -> props.put(String.format(JDT_CLASSPATH_VAR_FMT, name), value)));
    }

    @Override
    public void close() {
        if (!this.installedJres.isEmpty()) {
            this.extension.addSetupAction(new InstalledJreAdder(this.installedJres));
        }
    }

    private static /* synthetic */ void lambda$compilerComplianceLevel$63(List list, String string, Map props) {
        list.forEach(p -> props.put(p, JavaVersion.toVersion((Object)string).toString()));
        props.put("org.eclipse.jdt.core.compiler.codegen.inlineJsrBytecode", "enabled");
        props.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", "error");
        props.put("org.eclipse.jdt.core.compiler.problem.enumIdentifier", "error");
    }
}

