/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.eclipserunner;

import com.diffplug.common.base.Box;
import com.diffplug.common.base.Preconditions;
import com.diffplug.gradle.FileMisc;
import com.diffplug.gradle.eclipserunner.EclipseIni;
import com.diffplug.gradle.eclipserunner.launcher.Main;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import org.eclipse.core.runtime.adaptor.EclipseStarter;
import org.osgi.framework.BundleContext;

public class EclipseIniLauncher {
    final EclipseIni eclipseIni;

    public EclipseIniLauncher(File installationRoot) throws FileNotFoundException, IOException {
        FileMisc.assertMacApp(installationRoot);
        Objects.requireNonNull(installationRoot);
        this.eclipseIni = EclipseIni.parseFrom(new File(installationRoot, FileMisc.macContentsEclipse() + "eclipse.ini"));
    }

    public Running open() throws Exception {
        return new Running();
    }

    public void run() throws Exception {
        try (Running running = this.open();){
            running.run();
        }
    }

    public class Running
    implements AutoCloseable {
        final BundleContext bundleContext;

        private Running() throws Exception {
            final Box.Nullable context = Box.Nullable.ofNull();
            Main main = new Main(){

                @Override
                @SuppressFBWarnings(value={"DMI_THREAD_PASSED_WHERE_RUNNABLE_EXPECTED"}, justification="splashHandler is a thread rather than a runnable.  Almost definitely a small bug, but there's a lot of small bugs in the copy-pasted launcher code.  It's battle-tested, FWIW.")
                protected void invokeFramework(String[] passThruArgs, URL[] bootPath) throws Exception {
                    context.set((Object)EclipseStarter.startup((String[])passThruArgs, (Runnable)this.splashHandler));
                }
            };
            main.basicRun(EclipseIniLauncher.this.eclipseIni.getLinesAsArray());
            this.bundleContext = (BundleContext)Objects.requireNonNull(context.get());
        }

        public BundleContext bundleContext() {
            return this.bundleContext;
        }

        private void run() throws Exception {
            Object result = EclipseStarter.run(null);
            Preconditions.checkState((boolean)Integer.valueOf(0).equals(result), (String)"Unexpected return=0, was: %s", (Object[])new Object[]{result});
        }

        @Override
        public void close() throws Exception {
            EclipseStarter.shutdown();
        }
    }
}

