/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.eclipse;

import com.diffplug.gradle.ProjectPlugin;
import com.diffplug.gradle.eclipse.EclipseProjectPlugin;
import com.diffplug.gradle.eclipse.ResourceFilter;
import com.diffplug.gradle.eclipse.ResourceFiltersExtension;
import groovy.util.Node;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.gradle.api.Project;

public class ResourceFiltersPlugin
extends ProjectPlugin {
    ResourceFiltersExtension extension;
    static final String FILTERED_RESOURCES = "filteredResources";

    @Override
    protected void applyOnce(Project project) {
        this.extension = (ResourceFiltersExtension)project.getExtensions().create("eclipseResourceFilters", ResourceFiltersExtension.class, new Object[0]);
        EclipseProjectPlugin.modifyEclipseProject(project, eclipseModel -> eclipseModel.getProject().getFile().getXmlTransformer().addAction(xmlProvider -> {
            Node rootNode = xmlProvider.asNode();
            List<Node> toRemove = rootNode.children().stream().filter(Objects::nonNull).filter(node -> FILTERED_RESOURCES.equals(node.name())).collect(Collectors.toList());
            toRemove.forEach(arg_0 -> ((Node)rootNode).remove(arg_0));
            Node filteredResources = rootNode.appendNode((Object)FILTERED_RESOURCES);
            for (ResourceFilter toExclude : this.extension.filters) {
                toExclude.appendToFilteredResources(filteredResources);
            }
        }));
    }
}

