/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.pde;

import com.diffplug.common.base.Preconditions;
import com.diffplug.common.collect.ImmutableSet;
import com.diffplug.common.collect.Immutables;
import com.diffplug.common.collect.Maps;
import com.diffplug.gradle.Lazyable;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import org.osgi.framework.Version;

public class ExplicitVersionPolicy {
    private Map<String, Resolve> resolvable = Maps.newHashMap();

    @CheckReturnValue
    public Resolve resolve(String pluginName, String ... versions) {
        Resolve mapping = new Resolve(versions);
        this.resolvable.put(pluginName, mapping);
        return mapping;
    }

    public ExplicitVersionPolicy copy() {
        ExplicitVersionPolicy clone = new ExplicitVersionPolicy();
        this.resolvable.forEach((key, resolve) -> clone.resolvable.put((String)key, new Resolve((Resolve)resolve)));
        return clone;
    }

    Set<Version> useVersions(String plugin, Set<Version> present) {
        if (present.size() == 1) {
            if (this.resolvable.containsKey(plugin)) {
                throw new IllegalArgumentException("Expected " + this.resolvable.get(plugin).accepts + " for '" + plugin + "', but had only " + present);
            }
            return present;
        }
        if (present.isEmpty()) {
            throw new IllegalArgumentException("No such plugin: " + plugin);
        }
        Resolve mapping = this.resolvable.get(plugin);
        if (mapping == null) {
            throw new IllegalArgumentException("Conflicting versions for '" + plugin + "'!  Had " + present + ", call resolve(name, existingVersions).with(versionsToKeep)");
        }
        if (mapping.accepts.equals(present)) {
            Preconditions.checkNotNull((Object)mapping.takes, (String)"You forgot to call 'withFirst()' or some other resolution on %s", (Object[])new Object[]{mapping.takes});
            return mapping.takes;
        }
        throw new IllegalArgumentException("Conflicts don't match for '" + plugin + "'!  Suggested resolution was " + mapping.accepts + ", but available was " + present);
    }

    static Lazyable<ExplicitVersionPolicy> createLazyable() {
        return new Lazyable<ExplicitVersionPolicy>(new ExplicitVersionPolicy(), ExplicitVersionPolicy::copy);
    }

    public static class Resolve {
        private final ImmutableSet<Version> accepts;
        private ImmutableSet<Version> takes;

        private Resolve(String ... accepts) {
            Preconditions.checkArgument((accepts.length > 1 ? 1 : 0) != 0, (Object)"Only applies for plugins with multiple versions.");
            this.accepts = Resolve.parse(accepts);
        }

        private Resolve(Resolve source) {
            this.accepts = source.accepts;
            this.takes = source.takes;
        }

        public void with(String ... takes) {
            this.takes = Resolve.parse(takes);
            Preconditions.checkArgument((boolean)this.accepts.containsAll(this.takes), (String)"Takes %s must be a strict subset of accepts %s.", (Object[])new Object[]{takes, this.accepts});
        }

        public void withFirst() {
            this.takes = ImmutableSet.of((Object)((Version)this.accepts.asList().get(0)));
        }

        static ImmutableSet<Version> parse(String[] raw) {
            return (ImmutableSet)Arrays.asList(raw).stream().map(Version::parseVersion).collect(Immutables.toSet());
        }
    }
}

