/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.eclipserunner;

import com.diffplug.common.io.Files;
import com.diffplug.gradle.FileMisc;
import com.diffplug.gradle.eclipserunner.EquinoxLaunchSource;
import com.diffplug.gradle.eclipserunner.EquinoxLaunchTask;
import com.diffplug.gradle.p2.ParsedJar;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class EquinoxLaunchSetupTask
extends DefaultTask {
    @Input
    final EquinoxLaunchSource source = new EquinoxLaunchSource(this);
    @OutputDirectory
    File installDir;

    @TaskAction
    public void copyFiles() throws IOException {
        FileMisc.cleanDir(this.installDir);
        File pluginsDir = new File(this.installDir, "plugins");
        FileMisc.mkdirs(pluginsDir);
        for (File plugin : this.source.resolvedFiles()) {
            ParsedJar parsed = ParsedJar.parse(plugin);
            String name = parsed.getSymbolicName() + "_" + parsed.getVersion() + ".jar";
            Files.copy((File)plugin, (File)new File(pluginsDir, name));
        }
    }

    public EquinoxLaunchTask launchTask(Project project, String name) {
        EquinoxLaunchTask launchTask = (EquinoxLaunchTask)project.getTasks().create(name, EquinoxLaunchTask.class);
        launchTask.dependsOn(new Object[]{this});
        launchTask.setInstallDir(this.installDir);
        launchTask.setWorkingDir(this.getProject().getProjectDir());
        launchTask.setArgs(new ArrayList<String>());
        return launchTask;
    }

    public EquinoxLaunchTask launchTask(String name) {
        return this.launchTask(this.getProject(), name);
    }

    public EquinoxLaunchTask launchTask(String name, Action<EquinoxLaunchTask> configure) {
        EquinoxLaunchTask launchTask = this.launchTask(name);
        configure.execute((Object)launchTask);
        return launchTask;
    }

    public EquinoxLaunchSource getSource() {
        return this.source;
    }

    public File getInstallDir() {
        return this.installDir;
    }

    public void setInstallDir(File installDir) {
        this.installDir = installDir;
    }
}

