/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle;

import com.diffplug.common.collect.Maps;
import java.util.Map;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class LegacyPlugin
implements Plugin<Project> {
    private final Class<? extends Plugin<Project>> newPlugin;
    private final String newId;
    private static ThreadLocal<Map.Entry<Integer, Class<? extends LegacyPlugin>>> clazzBeingCompatApplied = new ThreadLocal();

    protected LegacyPlugin(Class<? extends Plugin<Project>> newPlugin, String newPluginId) {
        this.newPlugin = newPlugin;
        this.newId = newPluginId;
    }

    public void apply(Project proj) {
        Map.Entry cacheEntry = Maps.immutableEntry((Object)System.identityHashCode(proj), this.getClass());
        if (cacheEntry.equals(clazzBeingCompatApplied.get())) {
            clazzBeingCompatApplied.set(null);
            return;
        }
        proj.getPlugins().apply(this.newPlugin);
        String oldId = this.newId.equals("com.diffplug.osgi.equinoxlaunch") ? "com.diffplug.gradle.equinoxlaunch" : this.newId.replace("com.diffplug.", "com.diffplug.gradle.");
        System.err.println("Plugin '" + oldId + "' has been replaced by '" + this.newId + "'");
        System.err.println("   This is just a name change, there is no behavior change.");
        System.err.println("   The old id will keep working, but it will print this warning message.");
        System.err.println("   See here for reason: https://dev.to/nedtwigg/names-in-java-maven-and-gradle-2fm2");
    }

    public static void applyForCompat(Project proj, Class<? extends LegacyPlugin> clazz) {
        clazzBeingCompatApplied.set(Maps.immutableEntry((Object)System.identityHashCode(proj), clazz));
        proj.getPlugins().apply(clazz);
    }
}

