/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.gradle.api.Action;

public class Lazyable<C> {
    final Function<? super C, ? extends C> copier;
    final C root;
    final List<Action<? super C>> actions = new ArrayList<Action<? super C>>();

    public Lazyable(C root, Function<? super C, ? extends C> copier) {
        this.root = Objects.requireNonNull(root);
        this.copier = Objects.requireNonNull(copier);
    }

    public C getRoot() {
        return this.root;
    }

    public void addLazyAction(Action<? super C> action) {
        this.actions.add(action);
    }

    public C getResult() {
        Object copied = this.copier.apply(this.root);
        this.actions.forEach(action -> action.execute(copied));
        return copied;
    }

    public static <T> Lazyable<List<T>> ofList() {
        return Lazyable.ofArrayList();
    }

    public static <T> Lazyable<ArrayList<T>> ofArrayList() {
        return new Lazyable<ArrayList<T>>(new ArrayList(), toCopy -> new ArrayList(toCopy));
    }
}

