/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.pde;

import com.diffplug.common.collect.Maps;
import com.diffplug.common.io.Files;
import com.diffplug.common.swt.os.SwtPlatform;
import com.diffplug.gradle.FileMisc;
import com.diffplug.gradle.eclipserunner.EclipseApp;
import com.diffplug.gradle.pde.JdkConfig;
import com.diffplug.gradle.pde.PdeBuildProperties;
import com.diffplug.gradle.pde.PdeInstallation;
import com.diffplug.gradle.pde.PdeProductBuildConfig;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.Actions;

public class PdeBuildTask
extends DefaultTask {
    private Object destination;
    private Action<EclipseApp> appModifier = Actions.doNothing();
    private Object base;
    private List<Object> pluginPath = new ArrayList<Object>();
    private JdkConfig config = new JdkConfig(this.getProject());
    private Map<String, String> buildProperties = Maps.newLinkedHashMap();
    List<SwtPlatform> platforms = SwtPlatform.getAll();
    private Action<PdeProductBuildConfig> productConfig;

    public void destination(Object buildDir) {
        this.destination = buildDir;
    }

    public void base(Object base) {
        this.base = base;
    }

    public void addPluginPath(Object pluginPath) {
        this.pluginPath.add(pluginPath);
    }

    @Internal
    public JdkConfig getJdkConfig() {
        return this.config;
    }

    @Internal
    public Map<String, String> getProps() {
        return this.buildProperties;
    }

    public void setConfigs(SwtPlatform ... platforms) {
        this.platforms = Arrays.asList(platforms);
    }

    public void app(Action<EclipseApp> antModifier) {
        this.appModifier = Objects.requireNonNull(antModifier);
    }

    public void product(Action<PdeProductBuildConfig> productConfig) {
        this.productConfig = productConfig;
    }

    @TaskAction
    public void build() throws Exception {
        Objects.requireNonNull(this.destination, "destination must not be null!");
        Objects.requireNonNull(this.base, "base must not be null!");
        File destination = this.getProject().file(this.destination);
        FileMisc.cleanDir(destination);
        File base = this.getProject().file(this.base);
        PdeBuildProperties properties = new PdeBuildProperties();
        properties.setBasePlatform(SwtPlatform.getRunning());
        properties.setBuildDirectory(destination);
        properties.setProp("base", base.getAbsolutePath());
        properties.setConfigs(this.platforms);
        properties.setJDK(this.config);
        List<File> pluginPaths = FileMisc.parseListFile(this.getProject(), this.pluginPath);
        properties.setPluginPaths(pluginPaths);
        if (this.productConfig != null) {
            PdeProductBuildConfig product = new PdeProductBuildConfig(this.getProject());
            this.productConfig.execute((Object)product);
            ArrayList<File> arrayList = new ArrayList<File>();
            arrayList.addAll(pluginPaths);
            product.setup(destination, properties, this.platforms, arrayList);
        }
        for (Map.Entry entry : this.buildProperties.entrySet()) {
            properties.setProp((String)entry.getKey(), (String)entry.getValue());
        }
        File buildDirProperties = new File(destination, "build.properties");
        Files.write((CharSequence)properties.getContent(), (File)buildDirProperties, (Charset)StandardCharsets.UTF_8);
        PdeInstallation pdeInstallation = PdeInstallation.fromProject(this.getProject());
        EclipseApp app = pdeInstallation.productBuildCmd(destination);
        this.appModifier.execute((Object)app);
        app.runUsing(pdeInstallation);
    }
}

