/*
 * Decompiled with CFR 0.152.
 */
package com.didi.drouter.utils;

import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.util.ArrayMap;
import java.util.Collections;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class TextUtils {
    public static boolean isEmpty(@Nullable CharSequence str) {
        return str == null || str.length() == 0;
    }

    @NonNull
    public static Uri getUriKey(String uri) {
        if (uri == null) {
            return Uri.parse((String)"://");
        }
        return TextUtils.getUriKey(Uri.parse((String)uri));
    }

    @NonNull
    public static Uri getUriKey(Uri uri) {
        if (uri == null) {
            return Uri.parse((String)"://");
        }
        return Uri.parse((String)(TextUtils.getNonNull(uri.getScheme()).toLowerCase() + "://" + TextUtils.getNonNull(uri.getHost()).toLowerCase() + TextUtils.getNonNull(uri.getPath()).toLowerCase()));
    }

    private static String getNonNull(String content) {
        return content == null ? "" : content;
    }

    public static boolean isRegex(String string2) {
        return string2 != null && !string2.matches("[\\w/]*");
    }

    public static String getPath(String pathWithQuery) {
        if (pathWithQuery != null) {
            int index = pathWithQuery.indexOf("?");
            return index != -1 ? pathWithQuery.substring(0, index) : pathWithQuery;
        }
        return null;
    }

    @NonNull
    public static Map<String, String> getQuery(Uri rawUri) {
        if (rawUri == null) {
            return Collections.emptyMap();
        }
        return TextUtils.getQuery(rawUri.toString());
    }

    @NonNull
    public static Map<String, String> getQuery(String rawUri) {
        int end;
        if (rawUri == null) {
            return Collections.emptyMap();
        }
        int index = rawUri.indexOf("?");
        String query = index != -1 ? rawUri.substring(index + 1) : rawUri;
        index = query.indexOf("#");
        query = index != -1 ? query.substring(0, index) : query;
        ArrayMap paramMap = new ArrayMap();
        int start = 0;
        do {
            String name;
            int next;
            end = (next = query.indexOf(38, start)) == -1 ? query.length() : next;
            int separator = query.indexOf(61, start);
            if (separator > end || separator == -1) {
                separator = end;
            }
            if (android.text.TextUtils.isEmpty((CharSequence)(name = query.substring(start, separator)))) continue;
            String value = separator == end ? "" : query.substring(separator + 1, end);
            paramMap.put(name, value);
        } while ((start = end + 1) < query.length());
        return Collections.unmodifiableMap(paramMap);
    }

    public static void appendExtra(Bundle bundle, Map<String, String> extra) {
        for (Map.Entry<String, String> entry : extra.entrySet()) {
            bundle.putString(entry.getKey(), entry.getValue());
        }
    }
}

