/*
 * Decompiled with CFR 0.152.
 */
package com.didi.drouter.router;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import com.didi.drouter.router.HolderFragment;
import com.didi.drouter.router.IRouterHandler;
import com.didi.drouter.router.Monitor;
import com.didi.drouter.router.Request;
import com.didi.drouter.router.Result;
import com.didi.drouter.router.ResultAgent;
import com.didi.drouter.router.RouterCallback;
import com.didi.drouter.store.RouterMeta;
import com.didi.drouter.utils.RouterExecutor;
import com.didi.drouter.utils.RouterLogger;

class RouterDispatcher {
    RouterDispatcher() {
    }

    static void start(Request request, RouterMeta meta, Result result, RouterCallback callback) {
        RouterLogger.getCoreLogger().d("request \"%s\", class \"%s\" start execute", request.getNumber(), meta.getRouterClass() != null ? meta.getRouterClass().getSimpleName() : meta.getHandler());
        switch (meta.getRouterType()) {
            case 1: {
                RouterDispatcher.startActivity(request, meta, result, callback);
                break;
            }
            case 2: {
                RouterDispatcher.startFragment(request, meta, result);
                break;
            }
            case 3: {
                RouterDispatcher.startView(request, meta, result);
                break;
            }
            case 4: {
                RouterDispatcher.startHandler(request, meta, result);
                break;
            }
        }
    }

    private static void startActivity(Request request, RouterMeta meta, Result result, RouterCallback callback) {
        Context context = request.getContext();
        Intent intent = meta.getIntent();
        if (intent == null) {
            intent = new Intent();
            intent.setClassName(context, meta.getActivityClassName());
        }
        if (request.getExtra().containsKey("DRouter_start_activity_flags")) {
            intent.setFlags(request.getInt("DRouter_start_activity_flags"));
        }
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        intent.putExtra("DRouter_start_activity_request_number", request.getNumber());
        intent.putExtras(request.getExtra());
        if (context instanceof FragmentActivity && callback instanceof RouterCallback.ActivityCallback) {
            HolderFragment.start((FragmentActivity)context, intent, 1024, (RouterCallback.ActivityCallback)callback);
        } else if (context instanceof Activity && request.getExtra().containsKey("DRouter_start_activity_request_code")) {
            int requestCode = request.getInt("DRouter_start_activity_request_code");
            ActivityCompat.startActivityForResult((Activity)((Activity)context), (Intent)intent, (int)requestCode, (Bundle)intent.getBundleExtra("DRouter_start_activity_options"));
        } else {
            ActivityCompat.startActivity((Context)context, (Intent)intent, (Bundle)intent.getBundleExtra("DRouter_start_activity_options"));
        }
        int[] anim = request.getIntArray("DRouter_start_activity_animation");
        if (context instanceof Activity && anim != null && anim.length == 2) {
            ((Activity)context).overridePendingTransition(anim[0], anim[1]);
        }
        result.isActivityStarted = true;
        if (!meta.isHold()) {
            ResultAgent.release(request, "complete");
        } else {
            RouterLogger.getCoreLogger().w("request \"%s\" will be held", request.getNumber());
            Monitor.startMonitor(request, result);
        }
    }

    private static void startFragment(Request request, RouterMeta meta, Result result) {
        result.routerClass = meta.getRouterClass();
        if (request.getExtra().getBoolean("DRouter_start_fragment_new_instance", true)) {
            Object object;
            Object object2 = object = meta.getRouterProxy() != null ? meta.getRouterProxy().newInstance(null) : null;
            if (object instanceof Fragment) {
                result.fragment = (Fragment)object;
                result.fragment.setArguments(request.getExtra());
            }
        }
        ResultAgent.release(request, "complete");
    }

    private static void startView(Request request, RouterMeta meta, Result result) {
        result.routerClass = meta.getRouterClass();
        if (request.getExtra().getBoolean("DRouter_start_view_new_instance", true)) {
            Object object;
            Object object2 = object = meta.getRouterProxy() != null ? meta.getRouterProxy().newInstance(request.getContext()) : null;
            if (object instanceof View) {
                result.view = (View)object;
                result.view.setTag((Object)request.getExtra());
            }
        }
        ResultAgent.release(request, "complete");
    }

    private static void startHandler(final Request request, final RouterMeta meta, final Result result) {
        IRouterHandler handler = meta.getHandler();
        if (handler == null) {
            IRouterHandler iRouterHandler = handler = meta.getRouterProxy() != null ? (IRouterHandler)meta.getRouterProxy().newInstance(null) : null;
        }
        if (handler != null) {
            final IRouterHandler finalHandler = handler;
            RouterExecutor.execute(meta.getThread(), new Runnable(){

                @Override
                public void run() {
                    if (meta.isHold()) {
                        RouterLogger.getCoreLogger().w("request \"%s\" will hold", request.getNumber());
                    }
                    finalHandler.handle(request, result);
                    if (!meta.isHold()) {
                        ResultAgent.release(request, "complete");
                    } else {
                        Monitor.startMonitor(request, result);
                    }
                }
            });
        } else {
            ResultAgent.release(request, "error");
        }
    }
}

