/*
 * Decompiled with CFR 0.152.
 */
package com.didi.drouter.router;

import android.os.Handler;
import android.os.HandlerThread;
import com.didi.drouter.router.Request;
import com.didi.drouter.router.Result;
import com.didi.drouter.router.ResultAgent;
import com.didi.drouter.utils.RouterExecutor;
import com.didi.drouter.utils.RouterLogger;

class Monitor {
    private static Handler timeoutHandler;

    Monitor() {
    }

    static void startMonitor(final Request request, Result result) {
        long period = request.holdTimeout;
        if (period > 0L) {
            Monitor.check();
            RouterLogger.getCoreLogger().d("monitor for request \"%s\" start, count down \"%sms\"", request.getNumber(), period);
            timeoutHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    RouterExecutor.submit(new Runnable(){

                        @Override
                        public void run() {
                            ResultAgent.release(request, "timeout");
                        }
                    });
                }
            }, period);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void check() {
        if (timeoutHandler != null) return;
        Class<Monitor> clazz = Monitor.class;
        synchronized (Monitor.class) {
            if (timeoutHandler != null) return;
            HandlerThread handlerThread = new HandlerThread("timeout-monitor-thread");
            handlerThread.start();
            timeoutHandler = new Handler(handlerThread.getLooper());
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

