/*
 * Decompiled with CFR 0.152.
 */
package com.didi.drouter.page;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.ViewGroup;
import com.didi.drouter.page.IPageBean;
import com.didi.drouter.page.RouterPageAbs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RouterPageViewPager
extends RouterPageAbs {
    private final ViewPager viewPager;
    private final FragmentManager fragmentManager;
    private final ViewPagerAdapter adapter;
    private final List<String> curUriList = new ArrayList<String>();
    private final List<IPageBean> curInfoList = new ArrayList<IPageBean>();
    private List<String> lastUriList = new ArrayList<String>();
    private boolean showFlag = false;

    public RouterPageViewPager(FragmentManager manager, ViewPager container) {
        this.fragmentManager = manager;
        this.adapter = new ViewPagerAdapter(manager);
        this.viewPager = container;
        this.viewPager.setAdapter((PagerAdapter)this.adapter);
        this.viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                RouterPageViewPager.this.notifyPageChangedFromIndex(position, false, RouterPageViewPager.this.showFlag ? 1 : 0);
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
    }

    public void update(IPageBean ... beanList) {
        this.update(Arrays.asList(beanList));
    }

    public void update(@NonNull List<IPageBean> uriList) {
        this.lastUriList = (List)((ArrayList)this.curUriList).clone();
        this.curUriList.clear();
        this.curInfoList.clear();
        for (int i = 0; i < uriList.size(); ++i) {
            this.curUriList.add(uriList.get(i).getPageUri());
            this.curInfoList.add(uriList.get(i));
        }
        int lastPosition = this.viewPager.getCurrentItem();
        this.showFlag = true;
        this.adapter.notifyDataSetChanged();
        this.showFlag = false;
        int curPosition = this.viewPager.getCurrentItem();
        if (lastPosition == curPosition) {
            this.notifyPageChangedFromIndex(this.viewPager.getCurrentItem(), true, 1);
        }
    }

    private void notifyPageChangedFromIndex(int position, boolean filter, int changeType) {
        String lastUri = position < this.lastUriList.size() ? this.lastUriList.get(position) : "";
        IPageBean toBean = this.curInfoList.get(position);
        if (!filter || !lastUri.equals(toBean.getPageUri())) {
            this.notifyPageChanged(toBean, changeType);
        }
    }

    @Override
    public void showPage(@NonNull IPageBean bean) {
        int position = this.curUriList.indexOf(bean.getPageUri());
        if (position != -1) {
            this.showFlag = true;
            this.viewPager.setCurrentItem(position, false);
            this.showFlag = false;
        }
    }

    private static String makeFragmentName(int viewId, long position) {
        return "android:switcher:" + viewId + ":" + position;
    }

    private class ViewPagerAdapter
    extends FragmentPagerAdapter {
        ViewPagerAdapter(FragmentManager fm) {
            super(fm);
        }

        public Fragment getItem(int position) {
            Fragment fragment = RouterPageViewPager.this.newFragment((String)RouterPageViewPager.this.curUriList.get(position));
            Bundle info = null;
            if (RouterPageViewPager.this.curInfoList.get(position) != null && ((IPageBean)RouterPageViewPager.this.curInfoList.get(position)).getPageInfo() != null) {
                info = ((IPageBean)RouterPageViewPager.this.curInfoList.get(position)).getPageInfo();
            }
            RouterPageViewPager.this.putArgsForFragment(fragment, info);
            return fragment;
        }

        public Object instantiateItem(ViewGroup container, int position) {
            if (position < RouterPageViewPager.this.curUriList.size() && position < RouterPageViewPager.this.lastUriList.size() && !((String)RouterPageViewPager.this.curUriList.get(position)).equals(RouterPageViewPager.this.lastUriList.get(position))) {
                FragmentTransaction transaction = RouterPageViewPager.this.fragmentManager.beginTransaction();
                String name = RouterPageViewPager.makeFragmentName(container.getId(), position);
                Fragment fragment = RouterPageViewPager.this.fragmentManager.findFragmentByTag(name);
                if (fragment != null) {
                    transaction.remove(fragment);
                    transaction.commitNowAllowingStateLoss();
                }
            }
            return super.instantiateItem(container, position);
        }

        public int getCount() {
            return RouterPageViewPager.this.curUriList.size();
        }

        public int getItemPosition(Object object) {
            return -2;
        }
    }
}

