/*
 * Decompiled with CFR 0.152.
 */
package com.didi.drouter.page;

import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import com.didi.drouter.page.IPageBean;
import com.didi.drouter.page.RouterPageAbs;
import java.util.ArrayList;
import java.util.List;

public class RouterPageStack
extends RouterPageAbs {
    private final FragmentManager manager;
    private final int containerId;
    private final List<Fragment> fragments = new ArrayList<Fragment>();
    private final List<IPageBean> curInfoList = new ArrayList<IPageBean>();

    public RouterPageStack(FragmentManager manager, @IdRes int containerId) {
        this.manager = manager;
        this.containerId = containerId;
    }

    @Override
    public void showPage(@NonNull IPageBean bean) {
        Fragment fragment = this.newFragment(bean.getPageUri());
        this.putArgsForFragment(fragment, bean.getPageInfo());
        this.manager.beginTransaction().add(this.containerId, fragment).commitAllowingStateLoss();
        this.notifyPageChanged(bean, 1);
        this.fragments.add(fragment);
        this.curInfoList.add(bean);
    }

    @Override
    public void popPage() {
        if (!this.fragments.isEmpty()) {
            int index = this.fragments.size() - 1;
            Fragment fragment = this.fragments.remove(index);
            this.curInfoList.remove(index);
            this.manager.beginTransaction().remove(fragment).commitAllowingStateLoss();
            this.notifyPageChanged(index - 1 >= 0 && index - 1 < this.curInfoList.size() ? this.curInfoList.get(index - 1) : new IPageBean.EmptyPageBean(), 2);
        }
    }

    @Override
    @NonNull
    public IPageBean getCurPage() {
        return super.getCurPage();
    }
}

