/*
 * Decompiled with CFR 0.152.
 */
package com.didi.drouter.page;

import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.OnLifecycleEvent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.util.ArraySet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.didi.drouter.R;
import com.didi.drouter.api.DRouter;
import com.didi.drouter.page.IPageBean;
import com.didi.drouter.page.IPageRouter;
import com.didi.drouter.router.Result;
import com.didi.drouter.router.RouterCallback;
import com.didi.drouter.utils.RouterLogger;
import java.util.Set;

public abstract class RouterPageAbs
implements IPageRouter {
    protected Set<IPageRouter.IPageObserver> observers = new ArraySet();
    protected IPageBean currentPage = new IPageBean.EmptyPageBean();
    protected Bundle bundle = new Bundle();
    private IPageBean lastPage = new IPageBean.EmptyPageBean();
    private int lastChangeType;

    @Override
    public void popPage() {
    }

    @Override
    @NonNull
    public IPageBean getCurPage() {
        return this.currentPage;
    }

    @Override
    public Bundle execute(String method, Bundle bundle) {
        return null;
    }

    @Override
    public void addPageObserver(final IPageRouter.IPageObserver listener, boolean sticky, @Nullable LifecycleOwner owner) {
        if (listener != null) {
            if (!(!sticky || this.lastPage instanceof IPageBean.EmptyPageBean && this.currentPage instanceof IPageBean.EmptyPageBean)) {
                listener.onPageChange(this.lastPage, this.currentPage, this.lastChangeType);
            }
            this.observers.add(listener);
            if (owner != null) {
                owner.getLifecycle().addObserver(new LifecycleObserver(){

                    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
                    public void onDestroy(@NonNull LifecycleOwner owner) {
                        RouterPageAbs.this.removePageObserver(listener);
                    }
                });
            }
        }
    }

    @Override
    public void removePageObserver(IPageRouter.IPageObserver listener) {
        this.observers.remove(listener);
    }

    protected void notifyPageChanged(IPageBean toUri, int changeType) {
        for (IPageRouter.IPageObserver observer : this.observers) {
            observer.onPageChange(this.currentPage, toUri, changeType);
        }
        this.lastChangeType = changeType;
        this.lastPage = this.currentPage;
        this.currentPage = toUri;
    }

    @NonNull
    protected Fragment newFragment(String uri) {
        final Fragment[] fragments = new Fragment[]{null};
        DRouter.build(uri).start(null, new RouterCallback(){

            @Override
            public void onResult(@NonNull Result result) {
                fragments[0] = result.getFragment();
            }
        });
        if (fragments[0] == null) {
            RouterLogger.getCoreLogger().e("PageRouter get null fragment with uri: \"%s\", StackTrace:\n %s", uri, new Throwable());
            return new EmptyFragment();
        }
        return fragments[0];
    }

    protected void putArgsForFragment(Fragment fragment, Bundle ... bundles) {
        Bundle bundle = new Bundle();
        if (fragment.getArguments() != null) {
            bundle.putAll(fragment.getArguments());
        }
        for (Bundle arg : bundles) {
            if (arg == null) continue;
            bundle.putAll(arg);
        }
        fragment.setArguments(bundle);
    }

    public static class EmptyFragment
    extends Fragment {
        @Nullable
        public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
            TextView textView = new TextView(this.getContext());
            textView.setText(R.string.drouter_empty_fragment);
            return textView;
        }
    }
}

