/*
 * Decompiled with CFR 0.152.
 */
package com.didi.drouter.utils;

import android.content.Context;
import android.util.Log;
import android.widget.Toast;
import com.didi.drouter.api.DRouter;
import com.didi.drouter.utils.IRouterLogger;
import com.didi.drouter.utils.RouterExecutor;

public class RouterLogger {
    public static final String NAME = "DRouterCore";
    private static IRouterLogger logger = new InnerLogger();
    private static final RouterLogger coreLogger = new RouterLogger("DRouterCore");
    private static final RouterLogger appLogger = new RouterLogger("DRouterApp");
    private final String tag;

    private RouterLogger(String tag) {
        this.tag = tag;
    }

    public static void setLogger(IRouterLogger logger) {
        RouterLogger.logger = logger;
    }

    public static RouterLogger getAppLogger() {
        return appLogger;
    }

    public static RouterLogger getCoreLogger() {
        return coreLogger;
    }

    public void d(String content, Object ... args) {
        if (content != null && logger != null) {
            logger.d(this.tag, RouterLogger.format(content, args));
        }
    }

    public void w(String content, Object ... args) {
        if (content != null && logger != null) {
            logger.w(this.tag, RouterLogger.format(content, args));
        }
    }

    public void e(String content, Object ... args) {
        if (content != null && logger != null) {
            logger.e(this.tag, RouterLogger.format(content, args));
        }
    }

    public void crash(String content, Object ... args) {
        if (content != null && logger != null) {
            logger.e(this.tag, RouterLogger.format(content, args) + "\n Exception:" + Log.getStackTraceString((Throwable)new Throwable()));
        }
        throw new RuntimeException(content);
    }

    public static void toast(final String string2, final Object ... args) {
        RouterExecutor.main(new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)DRouter.getContext(), (CharSequence)RouterLogger.format(string2, args), (int)0).show();
            }
        });
    }

    private static String format(String s, Object ... args) {
        if (args == null) {
            return s;
        }
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof Throwable)) continue;
            args[i] = Log.getStackTraceString((Throwable)((Throwable)args[i]));
        }
        return String.format(s, args);
    }

    private static class InnerLogger
    implements IRouterLogger {
        private InnerLogger() {
        }

        @Override
        public void d(String tag, String content) {
            Log.d((String)tag, (String)content);
        }

        @Override
        public void w(String tag, String content) {
            Log.w((String)tag, (String)content);
        }

        @Override
        public void e(String tag, String content) {
            Log.e((String)tag, (String)content);
        }
    }
}

