/*
 * Decompiled with CFR 0.152.
 */
package com.didi.drouter.service;

import android.arch.lifecycle.LifecycleOwner;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.didi.drouter.remote.RemoteBridge;
import com.didi.drouter.service.ICallService;
import com.didi.drouter.service.ICallService0;
import com.didi.drouter.service.ICallService1;
import com.didi.drouter.service.ICallService2;
import com.didi.drouter.service.ICallService3;
import com.didi.drouter.service.ICallService4;
import com.didi.drouter.service.ICallService5;
import com.didi.drouter.service.ICallServiceN;
import com.didi.drouter.service.IFeatureMatcher;
import com.didi.drouter.store.IRouterProxy;
import com.didi.drouter.store.RouterMeta;
import com.didi.drouter.store.RouterStore;
import com.didi.drouter.utils.ReflectUtil;
import com.didi.drouter.utils.RouterLogger;
import com.didi.drouter.utils.TextUtils;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class ServiceAgent<T> {
    private static final Map<Class<?>, Object> sInstanceMap = new ConcurrentHashMap();
    private static final Map<Class<?>, WeakReference<Object>> sWeakInstanceMap = new ConcurrentHashMap();
    private final Map<Class<?>, RouterMeta> routerClassImplMap = new ConcurrentHashMap();
    private final Class<T> function;
    @NonNull
    private String alias = "";
    private Object feature;
    private String authority;
    private int resendStrategy;
    private WeakReference<LifecycleOwner> lifecycle;
    @Nullable
    private T defaultService;

    ServiceAgent(Class<T> function) {
        this.function = function;
        Set<RouterMeta> metaSet = RouterStore.getServiceMetas(function);
        for (RouterMeta meta : metaSet) {
            if (meta.getRouterType() != RouterMeta.SERVICE || meta.isDynamic()) continue;
            this.routerClassImplMap.put(meta.getRouterClass(), meta);
        }
    }

    void setAlias(String alias) {
        this.alias = alias != null ? alias : "";
    }

    void setFeature(Object feature) {
        this.feature = feature;
    }

    void setRemoteAuthority(String authority) {
        this.authority = authority;
    }

    void setRemoteDeadResend(int strategy) {
        this.resendStrategy = strategy;
    }

    void setLifecycleOwner(LifecycleOwner owner) {
        this.lifecycle = owner != null ? new WeakReference<LifecycleOwner>(owner) : null;
    }

    void setDefaultIfEmpty(T defaultService) {
        this.defaultService = defaultService;
    }

    @NonNull
    List<Class<? extends T>> getAllServiceClass() {
        ArrayList<Class<T>> result = new ArrayList<Class<T>>();
        if (this.function != null) {
            for (RouterMeta meta : this.routerClassImplMap.values()) {
                if (meta.isDynamic() || !this.match(meta.getServiceAlias(), meta.getFeatureMatcher())) continue;
                result.add(meta.getRouterClass());
            }
            if (result.size() > 1) {
                Collections.sort(result, new ServiceComparator());
            }
        }
        return result;
    }

    Class<? extends T> getServiceClass() {
        List<Class<T>> result = this.getAllServiceClass();
        if (!result.isEmpty()) {
            return result.get(0);
        }
        return null;
    }

    @NonNull
    List<T> getAllService(Object ... constructors) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.function != null) {
            for (RouterMeta routerMeta : RouterStore.getServiceMetas(this.function)) {
                if (!routerMeta.isDynamic() || !this.match(routerMeta.getServiceAlias(), routerMeta.getFeatureMatcher())) continue;
                result.add(routerMeta.getService());
            }
            for (Class clazz : this.getAllServiceClass()) {
                Object t = this.getServiceInstance(clazz, constructors);
                if (t == null) continue;
                result.add(t);
            }
        }
        return result;
    }

    T getService(Object ... constructors) {
        if (!TextUtils.isEmpty(this.authority)) {
            RouterLogger.getCoreLogger().d("[..] Get remote service \"%s\" by RemoteBridge", this.function.getSimpleName());
            return RemoteBridge.load(this.authority, this.resendStrategy, this.lifecycle).getService(this.function, this.alias, this.feature, constructors);
        }
        for (RouterMeta meta : RouterStore.getServiceMetas(this.function)) {
            if (!meta.isDynamic() || !this.match(meta.getServiceAlias(), meta.getFeatureMatcher())) continue;
            RouterLogger.getCoreLogger().d("[..] Get local dynamic service \"%s\" with result \"%s\"", this.function.getSimpleName(), meta.getService().getClass().getName());
            return (T)meta.getService();
        }
        Object target = this.getServiceInstance(this.getServiceClass(), constructors);
        if (target != null) {
            if (this.function == ICallService.class && CallHandler.isCallService(target)) {
                RouterLogger.getCoreLogger().d("[..] Get local ICallService service \"%s\" with result \"%s\"", this.function.getSimpleName(), target.getClass().getSimpleName());
                return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.function}, (InvocationHandler)new CallHandler(target));
            }
            RouterLogger.getCoreLogger().d("[..] Get local normal service \"%s\" with result \"%s\"", this.function.getSimpleName(), target.getClass().getSimpleName());
            return (T)target;
        }
        RouterLogger.getCoreLogger().w("[..] Get local service \"%s\" fail with default instance \"%s\"", this.function.getSimpleName(), this.defaultService != null ? this.defaultService.getClass().getName() : null);
        return this.defaultService;
    }

    private boolean match(String alias, IFeatureMatcher<Object> feature) {
        return this.alias.equals(alias) && (feature == null || feature.match(this.feature));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Nullable
    private Object getServiceInstance(Class<?> implClass, Object ... parameter) {
        if (implClass == null) {
            return null;
        }
        Object t = sInstanceMap.get(implClass);
        if (t == null && sWeakInstanceMap.containsKey(implClass)) {
            t = sWeakInstanceMap.get(implClass).get();
        }
        if (t == null) {
            Class<ServiceAgent> clazz = ServiceAgent.class;
            // MONITORENTER : com.didi.drouter.service.ServiceAgent.class
            t = sInstanceMap.get(implClass);
            if (t == null && sWeakInstanceMap.containsKey(implClass)) {
                t = sWeakInstanceMap.get(implClass).get();
            }
            if (t == null) {
                RouterMeta meta = this.routerClassImplMap.get(implClass);
                Object object = t = parameter != null && parameter.length == 0 && meta.getRouterProxy() != null ? meta.getRouterProxy().newInstance(null) : null;
                if (t == null) {
                    t = ReflectUtil.getInstance(implClass, parameter);
                }
                if (t != null) {
                    RouterLogger.getCoreLogger().d("[..] Create new service \"%s\" instance success", t.getClass().getSimpleName());
                    if (this.routerClassImplMap.get(implClass).getCache() == 2) {
                        sInstanceMap.put(implClass, t);
                        return t;
                    }
                    if (this.routerClassImplMap.get(implClass).getCache() == 1) {
                        sWeakInstanceMap.put(implClass, new WeakReference<Object>(t));
                    }
                    // MONITOREXIT : clazz
                    return t;
                }
            }
            // MONITOREXIT : clazz
        }
        if (t == null) return t;
        RouterLogger.getCoreLogger().d("[..] Get service \"%s\" instance by cache", t.getClass().getSimpleName());
        return t;
    }

    IRouterProxy getRouterProxy(Class<?> implClass) {
        RouterMeta meta = this.routerClassImplMap.get(implClass);
        if (meta != null) {
            return meta.getRouterProxy();
        }
        return null;
    }

    private class ServiceComparator
    implements Comparator<Class<?>> {
        private ServiceComparator() {
        }

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            int priority1 = ((RouterMeta)ServiceAgent.this.routerClassImplMap.get(o1)).getPriority();
            int priority2 = ((RouterMeta)ServiceAgent.this.routerClassImplMap.get(o2)).getPriority();
            return priority2 - priority1;
        }
    }

    private static class CallHandler
    implements InvocationHandler {
        Object callService;

        CallHandler(Object callService) {
            this.callService = callService;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object[] params = (Object[])args[0];
            if (params == null) {
                params = new Object[]{null};
            }
            if (this.callService instanceof ICallService0 && params.length == 0) {
                return ((ICallService0)this.callService).call();
            }
            if (this.callService instanceof ICallService1 && params.length == 1) {
                return ((ICallService1)this.callService).call(params[0]);
            }
            if (this.callService instanceof ICallService2 && params.length == 2) {
                return ((ICallService2)this.callService).call(params[0], params[1]);
            }
            if (this.callService instanceof ICallService3 && params.length == 3) {
                return ((ICallService3)this.callService).call(params[0], params[1], params[2]);
            }
            if (this.callService instanceof ICallService4 && params.length == 4) {
                return ((ICallService4)this.callService).call(params[0], params[1], params[2], params[3]);
            }
            if (this.callService instanceof ICallService5 && params.length == 5) {
                return ((ICallService5)this.callService).call(params[0], params[1], params[2], params[3], params[4]);
            }
            if (this.callService instanceof ICallServiceN) {
                return ((ICallServiceN)this.callService).call(params);
            }
            RouterLogger.getCoreLogger().e("%s not match with argument length %s ", this.callService.getClass().getSimpleName(), params.length);
            return null;
        }

        static boolean isCallService(Object instance) {
            return instance instanceof ICallService0 || instance instanceof ICallService1 || instance instanceof ICallService2 || instance instanceof ICallService3 || instance instanceof ICallService4 || instance instanceof ICallService5 || instance instanceof ICallServiceN;
        }
    }
}

