/*
 * Decompiled with CFR 0.152.
 */
package com.didi.drouter.router;

import android.support.annotation.NonNull;
import android.support.v4.util.ArrayMap;
import android.support.v4.util.ArraySet;
import com.didi.drouter.router.IRouterInterceptor;
import com.didi.drouter.store.RouterMeta;
import com.didi.drouter.store.RouterStore;
import com.didi.drouter.utils.ReflectUtil;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;

class InterceptorLoader {
    private static final Map<Class<? extends IRouterInterceptor>, IRouterInterceptor> sStaticInstanceMap = new ArrayMap();
    private static final Map<Class<? extends IRouterInterceptor>, WeakReference<IRouterInterceptor>> sWeakInstanceMap = new ArrayMap();
    private static final Set<Class<? extends IRouterInterceptor>> globalInterceptor = new ArraySet();

    InterceptorLoader() {
    }

    @NonNull
    static Queue<IRouterInterceptor> load(@NonNull RouterMeta meta) {
        ArraySet allInterceptors = new ArraySet(globalInterceptor);
        Class<? extends IRouterInterceptor>[] interceptors = meta.getInterceptors();
        if (interceptors != null) {
            allInterceptors.addAll(Arrays.asList(interceptors));
        }
        PriorityQueue<IRouterInterceptor> result = new PriorityQueue<IRouterInterceptor>(11, new InterceptorComparator());
        for (Class interceptorClass : allInterceptors) {
            result.add(InterceptorLoader.getInstance(interceptorClass));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IRouterInterceptor getInstance(Class<? extends IRouterInterceptor> clz) {
        IRouterInterceptor t = sStaticInstanceMap.get(clz);
        if (t == null && sWeakInstanceMap.containsKey(clz)) {
            t = (IRouterInterceptor)sWeakInstanceMap.get(clz).get();
        }
        if (t != null) return t;
        Class<InterceptorLoader> clazz = InterceptorLoader.class;
        synchronized (InterceptorLoader.class) {
            t = sStaticInstanceMap.get(clz);
            if (t == null && sWeakInstanceMap.containsKey(clz)) {
                t = (IRouterInterceptor)sWeakInstanceMap.get(clz).get();
            }
            if (t != null) return t;
            RouterMeta meta = RouterStore.getInterceptors().get(clz);
            if (meta == null) {
                meta = RouterMeta.build(RouterMeta.INTERCEPTOR).assembleInterceptor(clz, null, 0, false, 0);
                RouterStore.getInterceptors().put(clz, meta);
            }
            IRouterInterceptor iRouterInterceptor = t = meta.getRouterProxy() != null ? (IRouterInterceptor)meta.getRouterProxy().newInstance(null) : null;
            if (t == null) {
                t = (IRouterInterceptor)ReflectUtil.getInstance(clz, new Object[0]);
            }
            if (meta.getCache() == 2) {
                sStaticInstanceMap.put(clz, t);
            } else {
                if (meta.getCache() != 1) return t;
                sWeakInstanceMap.put(clz, new WeakReference<IRouterInterceptor>(t));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return t;
        }
    }

    static {
        for (Map.Entry<Class<? extends IRouterInterceptor>, RouterMeta> entry : RouterStore.getInterceptors().entrySet()) {
            if (!entry.getValue().isGlobal()) continue;
            globalInterceptor.add(entry.getKey());
        }
    }

    private static class InterceptorComparator
    implements Comparator<IRouterInterceptor> {
        private InterceptorComparator() {
        }

        @Override
        public int compare(IRouterInterceptor o1, IRouterInterceptor o2) {
            int priority1 = RouterStore.getInterceptors().get(o1.getClass()).getPriority();
            int priority2 = RouterStore.getInterceptors().get(o2.getClass()).getPriority();
            return priority2 - priority1;
        }
    }
}

