/*
 * Decompiled with CFR 0.152.
 */
package com.didi.drouter.router;

import android.support.annotation.NonNull;
import com.didi.drouter.router.IRouterInterceptor;
import com.didi.drouter.router.InterceptorLoader;
import com.didi.drouter.router.Request;
import com.didi.drouter.store.RouterMeta;
import com.didi.drouter.store.RouterStore;
import com.didi.drouter.utils.RouterLogger;
import java.util.Queue;

class InterceptorHandler {
    InterceptorHandler() {
    }

    static void handle(Request request, RouterMeta meta, IRouterInterceptor.IInterceptor callback) {
        RouterLogger.getCoreLogger().d(">> Enter request \"%s\" all interceptors", request.getNumber());
        Queue<IRouterInterceptor> interceptors = InterceptorLoader.load(meta);
        InterceptorHandler.handleNext(interceptors, request, callback);
    }

    private static void handleNext(final @NonNull Queue<IRouterInterceptor> interceptors, final Request request, final IRouterInterceptor.IInterceptor callback) {
        final IRouterInterceptor interceptor = interceptors.poll();
        if (interceptor == null) {
            RouterLogger.getCoreLogger().d("<< Pass request \"%s\" all interceptors", request.getNumber());
            callback.onContinue();
            return;
        }
        RouterMeta interceptorMeta = RouterStore.getInterceptors().get(interceptor.getClass());
        RouterLogger.getCoreLogger().d("interceptor \"%s\" execute, for request \"%s\", global:%s, priority:%s", interceptor.getClass().getSimpleName(), request.getNumber(), interceptorMeta.isGlobal(), interceptorMeta.getPriority());
        request.interceptor = new IRouterInterceptor.IInterceptor(){

            @Override
            public void onContinue() {
                InterceptorHandler.handleNext(interceptors, request, callback);
            }

            @Override
            public void onInterrupt() {
                RouterLogger.getCoreLogger().w("request \"%s\" interrupt by \"%s\"", request.getNumber(), interceptor.getClass().getSimpleName());
                callback.onInterrupt();
            }
        };
        interceptor.handle(request);
    }

    static class Default
    implements IRouterInterceptor.IInterceptor {
        Default() {
        }

        @Override
        public void onContinue() {
        }

        @Override
        public void onInterrupt() {
        }
    }
}

