/*
 * Decompiled with CFR 0.152.
 */
package com.didi.drouter.remote;

import android.content.Context;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.util.ArrayMap;
import android.support.v4.util.ArraySet;
import com.didi.drouter.api.DRouter;
import com.didi.drouter.remote.IClientService;
import com.didi.drouter.remote.IRemoteCallback;
import com.didi.drouter.remote.RemoteCommand;
import com.didi.drouter.remote.RemoteResult;
import com.didi.drouter.utils.JsonConverter;
import com.didi.drouter.utils.ReflectUtil;
import com.didi.drouter.utils.RouterLogger;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

class RemoteStream {
    RemoteStream() {
    }

    static Object transform(Object o) {
        if (RemoteStream.isParcelable(o)) {
            return o;
        }
        if (o.getClass().isArray()) {
            return new ArrayParcelable(o);
        }
        if (o instanceof Map) {
            return new MapParcelable(o);
        }
        if (o instanceof Collection) {
            return new CollectionParcelable(o);
        }
        if (o instanceof IRemoteCallback) {
            return new CallbackParcelable(o);
        }
        return new ObjectParcelable(o);
    }

    static Object reverse(Object o) {
        if (o instanceof ArrayParcelable) {
            return ((ArrayParcelable)o).getArray();
        }
        if (o instanceof MapParcelable) {
            return ((MapParcelable)o).getMap();
        }
        if (o instanceof CollectionParcelable) {
            return ((CollectionParcelable)o).getCollection();
        }
        if (o instanceof ObjectParcelable) {
            return ((ObjectParcelable)o).getObject();
        }
        if (o instanceof CallbackParcelable) {
            return ((CallbackParcelable)o).getObject();
        }
        return o;
    }

    private static boolean isParcelable(Object object) {
        return object == null || object instanceof Boolean || object instanceof boolean[] || object instanceof Byte || object instanceof byte[] || object instanceof Character || object instanceof char[] || object instanceof Short || object instanceof short[] || object instanceof Integer || object instanceof int[] || object instanceof Long || object instanceof long[] || object instanceof Float || object instanceof float[] || object instanceof Double || object instanceof double[] || object instanceof CharSequence || object instanceof CharSequence[] || object instanceof Parcelable || object instanceof Parcelable[] || object instanceof Class || object instanceof IBinder;
    }

    private static void writeSerializable(Parcel dest, Class<?> clz) {
        boolean isSerializable;
        boolean bl = isSerializable = !clz.isLocalClass() && !clz.isMemberClass() && !clz.isAnonymousClass() || (clz.getModifiers() & 8) != 0;
        if (!isSerializable) {
            throw new IllegalArgumentException(String.format("non static inner class \"%s\" can not be serialized", clz.getName()));
        }
        dest.writeSerializable(clz);
    }

    static class CallbackParcelable
    implements Parcelable {
        static Map<IRemoteCallback, IClientService> callbackPool = Collections.synchronizedMap(new WeakHashMap());
        IBinder binder;
        public static final Parcelable.Creator<CallbackParcelable> CREATOR = new Parcelable.Creator<CallbackParcelable>(){

            public CallbackParcelable createFromParcel(Parcel in) {
                return new CallbackParcelable(in);
            }

            public CallbackParcelable[] newArray(int size) {
                return new CallbackParcelable[size];
            }
        };

        CallbackParcelable(Object object) {
            final IRemoteCallback callback = (IRemoteCallback)object;
            IClientService callbackBinder = callbackPool.get(callback);
            if (callbackBinder == null) {
                callbackBinder = new IClientService.Stub(){

                    @Override
                    public RemoteResult callback(RemoteCommand callbackCommand) throws RemoteException {
                        RouterLogger.getCoreLogger().d("[Client] receive callback success and start invoke", new Object[0]);
                        callback.callback(callbackCommand.callbackData);
                        return null;
                    }
                };
                callbackPool.put(callback, callbackBinder);
            }
            this.binder = callbackBinder.asBinder();
        }

        CallbackParcelable(Parcel in) {
            this.binder = in.readStrongBinder();
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeStrongBinder(this.binder);
        }

        Object getObject() {
            for (Map.Entry<IRemoteCallback, IClientService> entry : callbackPool.entrySet()) {
                if (entry.getValue().asBinder() != this.binder) continue;
                return entry.getKey();
            }
            final IClientService callbackService = IClientService.Stub.asInterface(this.binder);
            IRemoteCallback callback = new IRemoteCallback(){

                @Override
                public void callback(Object ... data) throws RemoteException {
                    if (data == null) {
                        data = new Object[]{null};
                    }
                    RouterLogger.getCoreLogger().w("[Service] remote callback start invoke", new Object[0]);
                    RemoteCommand callbackCommand = new RemoteCommand(3);
                    callbackCommand.callbackData = data;
                    try {
                        callbackService.callback(callbackCommand);
                    }
                    catch (RemoteException e) {
                        RouterLogger.getCoreLogger().e("[Service] command callback Exception %s", new Object[]{e});
                        throw e;
                    }
                }
            };
            callbackPool.put(callback, callbackService);
            return callback;
        }

        public int describeContents() {
            return 0;
        }
    }

    static class ObjectParcelable
    implements Parcelable {
        Object object;
        public static final Parcelable.Creator<ObjectParcelable> CREATOR = new Parcelable.Creator<ObjectParcelable>(){

            public ObjectParcelable createFromParcel(Parcel in) {
                return new ObjectParcelable(in);
            }

            public ObjectParcelable[] newArray(int size) {
                return new ObjectParcelable[size];
            }
        };

        ObjectParcelable(Object object) {
            this.object = object;
        }

        ObjectParcelable(Parcel in) {
            int type = in.readInt();
            if (type == 0) {
                this.object = DRouter.getContext();
            } else {
                Class clz = (Class)in.readSerializable();
                this.object = JsonConverter.toObject(in.readString(), clz);
            }
        }

        public void writeToParcel(Parcel dest, int flags) {
            if (this.object instanceof Context) {
                dest.writeInt(0);
            } else {
                dest.writeInt(1);
                RemoteStream.writeSerializable(dest, this.object.getClass());
                dest.writeString(JsonConverter.toString(this.object));
            }
        }

        Object getObject() {
            return this.object;
        }

        public int describeContents() {
            return 0;
        }
    }

    static class CollectionParcelable
    implements Parcelable {
        Collection<Object> collection;
        public static final Parcelable.Creator<CollectionParcelable> CREATOR = new Parcelable.Creator<CollectionParcelable>(){

            public CollectionParcelable createFromParcel(Parcel in) {
                return new CollectionParcelable(in);
            }

            public CollectionParcelable[] newArray(int size) {
                return new CollectionParcelable[size];
            }
        };

        CollectionParcelable(Object o) {
            this.collection = (Collection)o;
        }

        CollectionParcelable(Parcel in) {
            Class clz = (Class)in.readSerializable();
            this.collection = clz == ArrayList.class ? new ArrayList<Object>() : (clz == HashSet.class ? new HashSet<Object>() : (clz == ArraySet.class ? new ArraySet() : (clz == LinkedList.class ? new LinkedList<Object>() : (Collection)ReflectUtil.getInstance(clz, new Object[0]))));
            ArrayList tmp = in.readArrayList(this.getClass().getClassLoader());
            for (Object object : tmp) {
                this.collection.add(RemoteStream.reverse(object));
            }
        }

        public void writeToParcel(Parcel dest, int flags) {
            Class<?> clz = this.collection.getClass();
            ArrayList<Object> tmp = new ArrayList<Object>();
            for (Object object : this.collection) {
                tmp.add(RemoteStream.transform(object));
            }
            RemoteStream.writeSerializable(dest, clz);
            dest.writeList(tmp);
        }

        Collection<Object> getCollection() {
            return this.collection;
        }

        public int describeContents() {
            return 0;
        }
    }

    static class MapParcelable
    implements Parcelable {
        Map<Object, Object> map;
        public static final Parcelable.Creator<MapParcelable> CREATOR = new Parcelable.Creator<MapParcelable>(){

            public MapParcelable createFromParcel(Parcel in) {
                return new MapParcelable(in);
            }

            public MapParcelable[] newArray(int size) {
                return new MapParcelable[size];
            }
        };

        MapParcelable(Object o) {
            this.map = (Map)o;
        }

        MapParcelable(Parcel in) {
            Class clz = (Class)in.readSerializable();
            this.map = clz == HashMap.class ? new HashMap<Object, Object>() : (clz == ArrayMap.class ? new ArrayMap() : (clz == ConcurrentHashMap.class ? new ConcurrentHashMap<Object, Object>() : (Map)ReflectUtil.getInstance(clz, new Object[0])));
            HashMap tmp = in.readHashMap(this.getClass().getClassLoader());
            for (Map.Entry entry : tmp.entrySet()) {
                this.map.put(RemoteStream.reverse(entry.getKey()), RemoteStream.reverse(entry.getValue()));
            }
        }

        public void writeToParcel(Parcel dest, int flags) {
            Class<?> clz = this.map.getClass();
            HashMap<Object, Object> tmp = new HashMap<Object, Object>();
            for (Map.Entry<Object, Object> entry : this.map.entrySet()) {
                tmp.put(RemoteStream.transform(entry.getKey()), RemoteStream.transform(entry.getValue()));
            }
            RemoteStream.writeSerializable(dest, clz);
            dest.writeMap(tmp);
        }

        Map<Object, Object> getMap() {
            return this.map;
        }

        public int describeContents() {
            return 0;
        }
    }

    static class ArrayParcelable
    implements Parcelable {
        Object[] array;
        public static final Parcelable.Creator<ArrayParcelable> CREATOR = new Parcelable.Creator<ArrayParcelable>(){

            public ArrayParcelable createFromParcel(Parcel in) {
                return new ArrayParcelable(in);
            }

            public ArrayParcelable[] newArray(int size) {
                return new ArrayParcelable[size];
            }
        };

        ArrayParcelable(Object o) {
            this.array = (Object[])o;
        }

        ArrayParcelable(Parcel in) {
            Class clz = (Class)in.readSerializable();
            Object[] tmp = in.readArray(this.getClass().getClassLoader());
            this.array = (Object[])Array.newInstance(clz, tmp.length);
            for (int i = 0; i < tmp.length; ++i) {
                this.array[i] = RemoteStream.reverse(tmp[i]);
            }
        }

        public void writeToParcel(Parcel dest, int flags) {
            Object[] tmp = new Object[this.array.length];
            for (int i = 0; i < this.array.length; ++i) {
                tmp[i] = RemoteStream.transform(this.array[i]);
            }
            RemoteStream.writeSerializable(dest, this.array.getClass().getComponentType());
            dest.writeArray(tmp);
        }

        Object[] getArray() {
            return this.array;
        }

        public int describeContents() {
            return 0;
        }
    }
}

