/*
 * Decompiled with CFR 0.152.
 */
package com.didi.drouter.page;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.ViewGroup;
import com.didi.drouter.page.IPageBean;
import com.didi.drouter.page.RouterPageAbs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RouterPageViewPager
extends RouterPageAbs {
    private final ViewPager viewPager;
    private final FragmentManager manager;
    private final ViewPagerAdapter adapter;
    private final List<String> curUriList = new ArrayList<String>();
    private final List<IPageBean> curInfoList = new ArrayList<IPageBean>();
    private List<String> lastUriList = new ArrayList<String>();

    public RouterPageViewPager(FragmentManager manager, ViewPager container) {
        this.manager = manager;
        this.adapter = new ViewPagerAdapter(manager);
        this.viewPager = container;
        this.viewPager.setAdapter((PagerAdapter)this.adapter);
        this.viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                RouterPageViewPager.this.notifyPageChanged(position);
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
    }

    public void update(IPageBean ... beanList) {
        this.update(Arrays.asList(beanList));
    }

    public void update(@NonNull List<IPageBean> uriList) {
        this.lastUriList = (List)((ArrayList)this.curUriList).clone();
        this.curUriList.clear();
        this.curInfoList.clear();
        for (int i = 0; i < uriList.size(); ++i) {
            this.curUriList.add(uriList.get(i).getPageUri());
            this.curInfoList.add(uriList.get(i));
        }
        this.adapter.notifyDataSetChanged();
        this.notifyPageChanged(this.viewPager.getCurrentItem());
    }

    private void notifyPageChanged(int position) {
        this.notifyPageChanged(position < this.curInfoList.size() ? this.curInfoList.get(position) : new IPageBean.EmptyPageBean());
    }

    @Override
    public void showPage(@NonNull IPageBean bean) {
        int index = this.curUriList.indexOf(bean.getPageUri());
        if (index != -1) {
            this.viewPager.setCurrentItem(index, false);
        }
    }

    private static String makeFragmentName(int viewId, long id) {
        return "android:switcher:" + viewId + ":" + id;
    }

    private class ViewPagerAdapter
    extends FragmentPagerAdapter {
        ViewPagerAdapter(FragmentManager fm) {
            super(fm);
        }

        public Fragment getItem(int position) {
            Fragment fragment = RouterPageViewPager.this.newFragment((String)RouterPageViewPager.this.curUriList.get(position));
            Bundle info = null;
            if (RouterPageViewPager.this.curInfoList.get(position) != null && ((IPageBean)RouterPageViewPager.this.curInfoList.get(position)).getPageInfo() != null) {
                info = ((IPageBean)RouterPageViewPager.this.curInfoList.get(position)).getPageInfo();
            }
            RouterPageViewPager.this.addArgsForFragment(fragment, info);
            return fragment;
        }

        public Object instantiateItem(ViewGroup container, int position) {
            if (position < RouterPageViewPager.this.curUriList.size() && position < RouterPageViewPager.this.lastUriList.size() && !((String)RouterPageViewPager.this.curUriList.get(position)).equals(RouterPageViewPager.this.lastUriList.get(position))) {
                FragmentTransaction transaction = RouterPageViewPager.this.manager.beginTransaction();
                String name = RouterPageViewPager.makeFragmentName(container.getId(), position);
                Fragment fragment = RouterPageViewPager.this.manager.findFragmentByTag(name);
                if (fragment != null) {
                    transaction.remove(fragment);
                    transaction.commitNowAllowingStateLoss();
                }
            }
            return super.instantiateItem(container, position);
        }

        public int getCount() {
            return RouterPageViewPager.this.curUriList.size();
        }

        public int getItemPosition(Object object) {
            return -2;
        }
    }
}

