/*
 * Decompiled with CFR 0.152.
 */
package com.didi.drouter.utils;

import android.app.ActivityManager;
import android.app.Application;
import android.os.Build;
import android.os.Process;
import android.support.annotation.RestrictTo;
import android.text.TextUtils;
import android.util.Log;
import com.didi.drouter.api.DRouter;
import java.lang.reflect.Method;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class SystemUtil {
    private static Application sApplication;
    private static String sProcessName;

    public static Application getApplication() {
        return sApplication;
    }

    public static void setApplication(Application application) {
        if (application != null) {
            sApplication = application;
        }
    }

    public static String getProcessName() {
        if (!TextUtils.isEmpty((CharSequence)sProcessName)) {
            return sProcessName;
        }
        if (Build.VERSION.SDK_INT >= 28) {
            sProcessName = Application.getProcessName();
        } else {
            try {
                Class<?> activityThread = Class.forName("android.app.ActivityThread");
                String methodName = Build.VERSION.SDK_INT >= 18 ? "currentProcessName" : "currentPackageName";
                Method getProcessName = activityThread.getDeclaredMethod(methodName, new Class[0]);
                sProcessName = (String)getProcessName.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                Log.e((String)"DRouterCore", (String)("getProcessName exception: " + e.getMessage()));
            }
        }
        if (!TextUtils.isEmpty((CharSequence)sProcessName)) {
            return sProcessName;
        }
        try {
            List runningApps;
            Application context = DRouter.getContext();
            ActivityManager am = (ActivityManager)context.getSystemService("activity");
            if (am != null && (runningApps = am.getRunningAppProcesses()) != null) {
                for (ActivityManager.RunningAppProcessInfo processInfo : runningApps) {
                    if (processInfo.pid != Process.myPid()) continue;
                    sProcessName = processInfo.processName;
                    return sProcessName;
                }
            }
            sProcessName = context.getPackageName();
        }
        catch (Exception e) {
            Log.e((String)"DRouterCore", (String)("getProcessName exception: " + e.getMessage()));
        }
        return sProcessName;
    }

    public static String getAppName() {
        try {
            int labelInfo = DRouter.getContext().getApplicationInfo().labelRes;
            return DRouter.getContext().getString(labelInfo);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static synchronized String getPackageName() {
        try {
            return DRouter.getContext().getPackageName();
        }
        catch (Exception e) {
            return null;
        }
    }
}

