/*
 * Decompiled with CFR 0.152.
 */
package com.didi.drouter.utils;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.RestrictTo;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class RouterExecutor {
    private static final Handler mainHandler = new Handler(Looper.getMainLooper());
    private static final ExecutorService threadPool = Executors.newCachedThreadPool();

    public static void execute(int mode, Runnable runnable) {
        switch (mode) {
            case 1: {
                RouterExecutor.main(runnable);
                break;
            }
            case 2: {
                RouterExecutor.worker(runnable);
                break;
            }
            default: {
                runnable.run();
            }
        }
    }

    public static void main(Runnable runnable) {
        RouterExecutor.main(runnable, 0L);
    }

    public static void main(Runnable runnable, long timeDelay) {
        if (Thread.currentThread() == Looper.getMainLooper().getThread() && timeDelay == 0L) {
            runnable.run();
        } else {
            mainHandler.postDelayed(runnable, timeDelay);
        }
    }

    public static void worker(Runnable runnable) {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            threadPool.submit(runnable);
        } else {
            runnable.run();
        }
    }

    public static void submit(Runnable runnable) {
        threadPool.submit(runnable);
    }
}

