/*
 * Decompiled with CFR 0.152.
 */
package com.didi.drouter.utils;

import com.didi.drouter.utils.RouterLogger;
import com.google.gson.Gson;

public class JsonConverter {
    private static IConvert jsonConvert;

    public static void setConverter(IConvert convert) {
        jsonConvert = convert;
    }

    public static String toString(Object object) {
        JsonConverter.check();
        return jsonConvert.toJson(object);
    }

    public static <T> T toObject(String json, Class<T> cls) {
        JsonConverter.check();
        T t = null;
        if (cls != null && !cls.getName().contains("com.android.internal")) {
            t = jsonConvert.fromJson(json, cls);
        }
        if (t == null) {
            RouterLogger.getCoreLogger().w("Json %s convert to object \"%s\" error", json, cls != null ? cls.getSimpleName() : null);
        }
        return t;
    }

    private static void check() {
        if (jsonConvert == null) {
            jsonConvert = new InnerConvert();
        }
    }

    private static class InnerConvert
    implements IConvert {
        private final Gson gson = new Gson();

        private InnerConvert() {
        }

        @Override
        public String toJson(Object obj) {
            return this.gson.toJson(obj);
        }

        @Override
        public <T> T fromJson(String json, Class<T> classOfT) {
            return (T)this.gson.fromJson(json, classOfT);
        }
    }

    public static interface IConvert {
        public String toJson(Object var1);

        public <T> T fromJson(String var1, Class<T> var2);
    }
}

