/*
 * Decompiled with CFR 0.152.
 */
package com.didi.drouter.router;

import android.app.Activity;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import com.didi.drouter.router.RouterCallback;
import com.didi.drouter.utils.RouterLogger;
import java.util.WeakHashMap;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class HolderFragment
extends Fragment {
    private static final String TAG = "DRouterEmptyFragment";
    private boolean attached;
    private static final WeakHashMap<Activity, RouterCallback.ActivityCallback> callback = new WeakHashMap();

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.attached = savedInstanceState.getBoolean("attached");
        }
    }

    public static void start(@NonNull FragmentActivity activity, @NonNull Intent intent, int requestCode, RouterCallback.ActivityCallback callback) {
        HolderFragment holdFragment = new HolderFragment();
        HolderFragment.callback.put((Activity)activity, callback);
        FragmentManager fragmentManager = activity.getSupportFragmentManager();
        FragmentTransaction transaction = fragmentManager.beginTransaction();
        transaction.add((Fragment)holdFragment, TAG);
        transaction.commit();
        RouterLogger.getCoreLogger().d("ActivityResult HoldFragment commit attach", new Object[0]);
        fragmentManager.executePendingTransactions();
        if (Build.VERSION.SDK_INT >= 16) {
            holdFragment.startActivityForResult(intent, requestCode, intent.getBundleExtra("DRouter_start_activity_options"));
        } else {
            holdFragment.startActivityForResult(intent, requestCode);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        RouterCallback.ActivityCallback cb = callback.get(this.getActivity());
        if (cb != null) {
            RouterLogger.getCoreLogger().d("ActivityResult callback", new Object[0]);
            cb.onActivityResult(resultCode, data);
        } else {
            RouterLogger.getCoreLogger().d("ActivityResult callback fail for host activity destroyed", new Object[0]);
        }
        callback.clear();
    }

    public void onResume() {
        super.onResume();
        if (this.attached) {
            FragmentManager fragmentManager = this.getFragmentManager();
            FragmentTransaction transaction = fragmentManager.beginTransaction();
            transaction.remove((Fragment)this);
            transaction.commit();
            this.attached = false;
            RouterLogger.getCoreLogger().d("ActivityResult HoldFragment commit remove", new Object[0]);
        }
        this.attached = true;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("attached", this.attached);
    }

    public void onDestroy() {
        super.onDestroy();
    }
}

