/*
 * Decompiled with CFR 0.152.
 */
package com.didi.drouter.remote;

import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.OnLifecycleEvent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.didi.drouter.api.DRouter;
import com.didi.drouter.remote.IClientService;
import com.didi.drouter.remote.IHostService;
import com.didi.drouter.remote.RemoteCommand;
import com.didi.drouter.remote.RemoteProvider;
import com.didi.drouter.remote.RemoteResult;
import com.didi.drouter.router.Request;
import com.didi.drouter.router.Result;
import com.didi.drouter.router.RouterCallback;
import com.didi.drouter.router.RouterHelper;
import com.didi.drouter.service.ServiceLoader;
import com.didi.drouter.utils.RouterLogger;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class RemoteBridge {
    private String authority;
    private int resendStrategy;
    private boolean reTry;
    private WeakReference<LifecycleOwner> lifecycle;
    private static final Map<String, Set<RemoteCommand>> sResendCommandMap = new ConcurrentHashMap<String, Set<RemoteCommand>>();
    private static final Map<String, IHostService> sHostServiceMap = new ConcurrentHashMap<String, IHostService>();
    private static final Map<String, String> sProcessMap = new ConcurrentHashMap<String, String>();

    private RemoteBridge() {
    }

    @NonNull
    public static RemoteBridge load(String authority, int resend, WeakReference<LifecycleOwner> lifecycle) {
        RemoteBridge remoteBridge = new RemoteBridge();
        remoteBridge.authority = authority;
        remoteBridge.resendStrategy = resend;
        remoteBridge.lifecycle = lifecycle;
        return remoteBridge;
    }

    public void start(final Request request, final Result result, RouterCallback callback) {
        RouterLogger.getCoreLogger().d("[Client] request \"%s\" start IPC", request.getNumber());
        final RemoteCommand command = new RemoteCommand(0);
        command.bridge = this;
        command.resendStrategy = this.resendStrategy;
        command.lifecycle = this.lifecycle;
        command.uri = request.getUri().toString();
        command.extra = request.getExtra();
        command.addition = request.getAddition();
        if (callback != null) {
            command.binder = new IClientService.Stub(){

                @Override
                public RemoteResult callback(RemoteCommand resultCommand) throws RemoteException {
                    RouterLogger.getCoreLogger().w("[Client] command \"%s\" callback success", command);
                    result.extra = resultCommand.extra;
                    result.addition = resultCommand.addition;
                    RouterHelper.release(request);
                    return null;
                }
            };
        } else {
            RouterLogger.getCoreLogger().d("[Client] request \"%s\" complete ahead of time", request.getNumber());
            RouterHelper.release(request);
        }
        this.execute(command);
    }

    public <T> T getService(Class<T> serviceClass, String alias, Object feature, Object ... constructor) {
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{serviceClass}, (InvocationHandler)new RemoteHandler(serviceClass, alias, feature, constructor));
    }

    @Nullable
    private RemoteResult execute(RemoteCommand command) {
        RouterLogger.getCoreLogger().d("[Client] execute command start, authority \"%s\", reTry:%s", this.authority, this.reTry);
        RemoteResult result = null;
        IHostService service = RemoteBridge.getHostService(this.authority);
        if (service != null) {
            try {
                this.retainResendCommand(command);
                result = service.execute(command);
                if (result != null) {
                    if ("success".equals(result.state)) {
                        RouterLogger.getCoreLogger().d("[Client] command \"%s\" return and state success", command);
                    } else {
                        RouterLogger.getCoreLogger().e("[Client] command \"%s\" return and state fail", command);
                    }
                } else {
                    RouterLogger.getCoreLogger().e("[Client] command \"%s\" remote inner error with early termination", command);
                }
            }
            catch (RemoteException e) {
                RouterLogger.getCoreLogger().e("[Client] remote RemoteException: %s", new Object[]{e});
                if (!this.reTry) {
                    this.reTry = true;
                    sHostServiceMap.remove(this.authority);
                    return this.execute(command);
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                RouterLogger.getCoreLogger().e("[Client] remote RuntimeException: %s", e);
            }
        }
        RouterLogger.getCoreLogger().d("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~", new Object[0]);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void retainResendCommand(final RemoteCommand command) {
        Object object;
        LifecycleOwner owner;
        final String process = sProcessMap.get(this.authority);
        if (process == null) {
            RouterLogger.getCoreLogger().e("[Client] add resend command fail, for process is null", new Object[0]);
            return;
        }
        final Lifecycle lifecycle = command.lifecycle != null ? ((owner = (LifecycleOwner)command.lifecycle.get()) != null ? owner.getLifecycle() : null) : null;
        if (command.resendStrategy != 1) return;
        if (lifecycle != null && lifecycle.getCurrentState() == Lifecycle.State.DESTROYED) {
            RouterLogger.getCoreLogger().e("[Client] add resend command fail, for lifecycle is destroyed", new Object[0]);
            return;
        }
        Set<RemoteCommand> resendCommands = sResendCommandMap.get(process);
        if (resendCommands == null) {
            object = ServiceLoader.class;
            // MONITORENTER : com.didi.drouter.service.ServiceLoader.class
            resendCommands = sResendCommandMap.get(process);
            if (resendCommands == null) {
                resendCommands = Collections.newSetFromMap(new ConcurrentHashMap());
                sResendCommandMap.put(process, resendCommands);
            }
            // MONITOREXIT : object
        }
        if (resendCommands.contains(command)) return;
        object = this;
        // MONITORENTER : object
        if (!resendCommands.contains(command)) {
            resendCommands.add(command);
            if (lifecycle != null) {
                lifecycle.addObserver(new LifecycleObserver(){

                    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
                    public void onDestroy(@NonNull LifecycleOwner owner) {
                        Set commands = (Set)sResendCommandMap.get(process);
                        if (commands != null) {
                            commands.remove(command);
                            RouterLogger.getCoreLogger().w("[Client] remove resend command: \"%s\"", command);
                        }
                        lifecycle.removeObserver((LifecycleObserver)this);
                    }
                });
            }
        }
        // MONITOREXIT : object
        RouterLogger.getCoreLogger().w("[Client] add resend command: \"%s\", with current lifecycle: %s", command, lifecycle != null ? lifecycle.getCurrentState() : null);
    }

    private static void registerBroadcast(String process) {
        BroadcastReceiver receiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String process = intent.getStringExtra("field_remote_launch_action");
                RouterLogger.getCoreLogger().w("receive broadcast remote app launcher process: \"%s\"", process);
                RemoteBridge.resendRemoteCommand(process);
            }
        };
        IntentFilter filter = new IntentFilter();
        filter.addAction("drouter.process.action." + process);
        DRouter.getContext().registerReceiver(receiver, filter);
    }

    private static void resendRemoteCommand(String process) {
        Set<RemoteCommand> commands = sResendCommandMap.get(process);
        if (commands != null) {
            for (RemoteCommand command : commands) {
                RouterLogger.getCoreLogger().w("execute resend command: \"%s\"", command);
                command.bridge.execute(command);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IHostService getHostService(final String authority) {
        IHostService service = sHostServiceMap.get(authority);
        if (service != null) {
            return service;
        }
        try {
            Class<RemoteCommand> clazz = RemoteCommand.class;
            synchronized (RemoteCommand.class) {
                service = sHostServiceMap.get(authority);
                if (service != null) {
                    RouterLogger.getCoreLogger().d("[Client] getHostService get binder with cache", new Object[0]);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return service;
                }
                Bundle bundle = null;
                for (int i = 0; i < 3; ++i) {
                    try {
                        bundle = DRouter.getContext().getContentResolver().call(Uri.parse((String)(authority.startsWith("content://") ? authority : "content://" + authority)), "", "", null);
                    }
                    catch (RuntimeException e) {
                        RouterLogger.getCoreLogger().e("[Client] getHostService call provider, try time %s, exception: %s", i, e.getMessage());
                    }
                    if (bundle != null) break;
                }
                boolean binderState = false;
                boolean registerBroadcast = false;
                String process = "";
                if (bundle != null) {
                    bundle.setClassLoader(RemoteBridge.class.getClassLoader());
                    RemoteProvider.BinderParcel parcel = (RemoteProvider.BinderParcel)bundle.getParcelable("field_remote_binder");
                    process = bundle.getString("field_remote_process");
                    if (parcel != null) {
                        service = IHostService.Stub.asInterface(parcel.getBinder());
                        service.asBinder().linkToDeath(new IBinder.DeathRecipient(){

                            public void binderDied() {
                                sHostServiceMap.remove(authority);
                                RouterLogger.getCoreLogger().e("[Client] linkToDeath: remote \"%s\" is died", authority);
                            }
                        }, 0);
                        sHostServiceMap.put(authority, service);
                        binderState = true;
                    }
                    if (process != null && !sProcessMap.containsKey(authority)) {
                        sProcessMap.put(authority, process);
                        RemoteBridge.registerBroadcast(process);
                        registerBroadcast = true;
                    }
                }
                RouterLogger.getCoreLogger().d("[Client] getHostService get binder: %s, process: \"%s\", register broadcast: %s", binderState, process, registerBroadcast);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return service;
            }
        }
        catch (RemoteException e) {
            RouterLogger.getCoreLogger().e("[Client] getHostService remote exception: %s", new Object[]{e});
            return null;
        }
    }

    public static IBinder getHostBinder(String authority) {
        IHostService service = sHostServiceMap.get(authority);
        return service != null ? service.asBinder() : null;
    }

    private class RemoteHandler
    implements InvocationHandler {
        private final Class<?> serviceClass;
        private final String alias;
        private final Object feature;
        private final Object[] constructor;

        RemoteHandler(Class<?> serviceClass, String alias, @Nullable Object feature, Object ... constructor) {
            this.serviceClass = serviceClass;
            this.alias = alias;
            this.feature = feature;
            this.constructor = constructor;
        }

        @Override
        public Object invoke(Object proxy, Method method, @Nullable Object[] parameters) {
            RemoteCommand command = new RemoteCommand(2);
            command.bridge = RemoteBridge.this;
            command.lifecycle = RemoteBridge.this.lifecycle;
            command.resendStrategy = RemoteBridge.this.resendStrategy;
            command.serviceClass = this.serviceClass;
            command.alias = this.alias;
            command.feature = this.feature;
            command.constructor = this.constructor;
            command.methodName = method.getName();
            command.parameters = parameters;
            RouterLogger.getCoreLogger().d("[Client] command: \"%s\" start IPC", command);
            RemoteResult result = RemoteBridge.this.execute(command);
            if (result != null && "success".equals(result.state)) {
                return result.result;
            }
            Class<?> returnType = method.getReturnType();
            if (returnType.isPrimitive()) {
                if (returnType == Boolean.TYPE) {
                    return false;
                }
                if (returnType == Character.TYPE) {
                    return Character.valueOf('0');
                }
                return 0;
            }
            return null;
        }
    }
}

