/*
 * Decompiled with CFR 0.152.
 */
package com.didi.aoe.runtime.tensorflow.lite;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.didi.aoe.library.api.AoeModelOption;
import com.didi.aoe.library.api.AoeProcessor;
import com.didi.aoe.library.api.convertor.MultiConvertor;
import com.didi.aoe.library.api.interpreter.InterpreterInitResult;
import com.didi.aoe.library.api.interpreter.OnInterpreterInitListener;
import com.didi.aoe.library.api.interpreter.SingleInterpreterComponent;
import com.didi.aoe.library.common.util.FileUtils;
import com.didi.aoe.library.logging.Logger;
import com.didi.aoe.library.logging.LoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import org.tensorflow.lite.Interpreter;
import org.tensorflow.lite.Tensor;

public abstract class TensorFlowLiteMultipleInputsOutputsInterpreter<TInput, TOutput, TModelInput, TModelOutput>
extends SingleInterpreterComponent<TInput, TOutput>
implements MultiConvertor<TInput, TOutput, Object, TModelOutput> {
    private final Logger mLogger = LoggerFactory.getLogger((String)"TFLite.Interpreter");
    private Interpreter mInterpreter;
    private Map<Integer, Object> mOutputPlaceholder;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(@NonNull Context context, @Nullable AoeProcessor.InterpreterComponent.Options interpreterOptions, @NonNull AoeModelOption modelOptions, @Nullable OnInterpreterInitListener listener) {
        ByteBuffer bb;
        block10: {
            String modelFilePath;
            String modelSource = modelOptions.getModelSource();
            bb = null;
            if ("cloud".equals(modelSource)) {
                modelFilePath = modelOptions.getModelDir() + "_" + modelOptions.getVersion() + File.separator + modelOptions.getModelName();
                File modelFile = new File(FileUtils.getFilesDir((Context)context), modelFilePath);
                if (modelFile.exists()) {
                    try {
                        bb = this.loadFromExternal(context, modelFilePath);
                    }
                    catch (Exception e) {
                        this.mLogger.warn("IOException", (Throwable)e);
                    }
                    break block10;
                } else {
                    if (listener != null) {
                        listener.onInitResult(InterpreterInitResult.create((int)3));
                    }
                    return;
                }
            }
            modelFilePath = modelOptions.getModelDir() + File.separator + modelOptions.getModelName();
            bb = this.loadFromAssets(context, modelFilePath);
        }
        if (bb != null) {
            Interpreter.Options options = null;
            if (interpreterOptions != null) {
                options = new Interpreter.Options().setNumThreads(interpreterOptions.getNumThreads());
            }
            this.mInterpreter = new Interpreter(bb, options);
            this.mOutputPlaceholder = this.generalOutputPlaceholder(this.mInterpreter);
            if (listener != null) {
                listener.onInitResult(InterpreterInitResult.create((int)0));
            }
            return;
        }
        if (listener != null) {
            listener.onInitResult(InterpreterInitResult.create((int)-2));
        }
    }

    private ByteBuffer loadFromExternal(Context context, String modelFilePath) throws IOException {
        FileInputStream fis = new FileInputStream(FileUtils.getFilesDir((Context)context) + File.separator + modelFilePath);
        FileChannel fileChannel = fis.getChannel();
        long startOffset = fileChannel.position();
        long declaredLength = fileChannel.size();
        return fileChannel.map(FileChannel.MapMode.READ_ONLY, startOffset, declaredLength);
    }

    private Map<Integer, Object> generalOutputPlaceholder(@NonNull Interpreter interpreter) {
        HashMap<Integer, Object> out = new HashMap<Integer, Object>(interpreter.getOutputTensorCount());
        for (int i = 0; i < interpreter.getOutputTensorCount(); ++i) {
            Tensor tensor = interpreter.getOutputTensor(i);
            Object data = null;
            switch (tensor.dataType()) {
                case FLOAT32: {
                    data = Array.newInstance(Float.TYPE, tensor.shape());
                    break;
                }
                case INT32: {
                    data = Array.newInstance(Integer.TYPE, tensor.shape());
                    break;
                }
                case UINT8: {
                    data = Array.newInstance(Byte.TYPE, tensor.shape());
                    break;
                }
                case INT64: {
                    data = Array.newInstance(Long.TYPE, tensor.shape());
                    break;
                }
                case STRING: {
                    data = Array.newInstance(String.class, tensor.shape());
                    break;
                }
            }
            out.put(i, data);
        }
        return out;
    }

    @Nullable
    public TOutput run(@NonNull TInput input) {
        Object[] modelInput;
        if (this.isReady() && (modelInput = this.preProcessMulti(input)) != null) {
            this.mInterpreter.runForMultipleInputsOutputs(modelInput, this.mOutputPlaceholder);
            return (TOutput)this.postProcessMulti(this.mOutputPlaceholder);
        }
        return null;
    }

    public void release() {
        if (this.mInterpreter != null) {
            this.mInterpreter.close();
        }
    }

    public boolean isReady() {
        return this.mInterpreter != null && this.mOutputPlaceholder != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer loadFromAssets(Context context, String modelFilePath) {
        block16: {
            ByteBuffer byteBuffer;
            InputStream is = null;
            try {
                is = context.getAssets().open(modelFilePath);
                byte[] bytes = FileUtils.read((InputStream)is);
                if (bytes == null) {
                    ByteBuffer byteBuffer2 = null;
                    return byteBuffer2;
                }
                ByteBuffer bf = ByteBuffer.allocateDirect(bytes.length);
                bf.order(ByteOrder.nativeOrder());
                bf.put(bytes);
                byteBuffer = bf;
            }
            catch (IOException e) {
                this.mLogger.error("loadFromAssets error", (Throwable)e);
                break block16;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return byteBuffer;
        }
        return null;
    }
}

