/*
 * Decompiled with CFR 0.152.
 */
package com.didi.aoe.library.modeloption.loader.impl;

import android.content.Context;
import androidx.annotation.NonNull;
import com.didi.aoe.library.api.AoeModelOption;
import com.didi.aoe.library.api.AoeProcessor;
import com.didi.aoe.library.common.util.FileUtils;
import com.didi.aoe.library.lang.AoeIOException;
import com.didi.aoe.library.logging.Logger;
import com.didi.aoe.library.logging.LoggerFactory;
import com.didi.aoe.library.modeloption.loader.pojos.LocalModelOption;
import com.google.gson.Gson;
import java.io.File;
import java.io.InputStream;

public final class LocalOnlyModelOptionLoader
implements AoeProcessor.ModelOptionLoaderComponent {
    private static final String CONFIG_FILE_NAME = "model.config";
    private final Logger mLogger = LoggerFactory.getLogger((String)"LocalOnlyModelOptionLoader");

    public AoeModelOption load(@NonNull Context context, @NonNull String modelDir) throws AoeIOException {
        LocalModelOption option = null;
        String config = null;
        try (InputStream is = context.getAssets().open(modelDir + File.separator + CONFIG_FILE_NAME);){
            config = new String(FileUtils.read((InputStream)is));
            option = (LocalModelOption)new Gson().fromJson(config, LocalModelOption.class);
        }
        catch (Exception e) {
            throw new AoeIOException("Parse LocalModelOption failed: ", (Throwable)e);
        }
        this.mLogger.debug("Parse LocalModelOption: " + option, new Object[0]);
        if (option == null || !option.isValid()) {
            throw new AoeIOException("Some fields of this config is empty: " + option);
        }
        return option;
    }
}

