/*
 * Decompiled with CFR 0.152.
 */
package com.didi.aoe.library.modeloption.loader.utils;

import androidx.annotation.RestrictTo;
import com.didi.aoe.library.logging.Logger;
import com.didi.aoe.library.logging.LoggerFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class FileUtil {
    private static final Logger mLogger = LoggerFactory.getLogger((String)"FileUtil");

    private FileUtil() {
    }

    public static boolean isExist(String filePath) {
        File file = new File(filePath);
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] read(InputStream is) {
        BufferedInputStream bis = null;
        ByteArrayOutputStream baos = null;
        try {
            int len;
            bis = new BufferedInputStream(is);
            baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = bis.read(buf)) != -1) {
                baos.write(buf, 0, len);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            mLogger.error(e.toString(), new Object[0]);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private static byte[] read(String filePath) {
        try {
            FileInputStream fis = new FileInputStream(filePath);
            return FileUtil.read(fis);
        }
        catch (Exception e) {
            mLogger.error(e.toString(), new Object[0]);
            return null;
        }
    }

    public static String readString(String filePath) {
        byte[] bytes = FileUtil.read(filePath);
        if (bytes == null) {
            return null;
        }
        return new String(bytes);
    }

    public static String readString(InputStream is) {
        byte[] bytes = FileUtil.read(is);
        if (bytes == null) {
            return null;
        }
        return new String(bytes);
    }
}

