/*
 * Decompiled with CFR 0.152.
 */
package com.didi.aoe.library.modeloption.loader.utils;

import com.didi.aoe.library.logging.Logger;
import com.didi.aoe.library.logging.LoggerFactory;
import com.google.gson.Gson;

public class JsonUtil {
    private static final Logger mLogger = LoggerFactory.getLogger((String)"JsonUtil");

    public static String jsonFromObject(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return new Gson().toJson(object);
        }
        catch (Exception e) {
            mLogger.error("JsonUtil", new Object[]{e.getMessage()});
            return null;
        }
    }

    public static <T> T objectFromJson(String json, Class<T> klass) {
        if (json == null) {
            return null;
        }
        try {
            return (T)new Gson().fromJson(json, klass);
        }
        catch (Exception e) {
            mLogger.error("JsonUtil", new Object[]{e.getMessage()});
            return null;
        }
    }
}

