/*
 * Decompiled with CFR 0.152.
 */
package com.didi.aoe.library.api.interpreter;

public final class InterpreterInitResult {
    private int code;
    private String msg;

    private InterpreterInitResult(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static InterpreterInitResult create(int code) {
        return InterpreterInitResult.create(code, InterpreterInitResult.generalCodeName(code));
    }

    public static InterpreterInitResult create(int code, String msg) {
        return new InterpreterInitResult(code, msg);
    }

    public String toString() {
        return "InterpreterInitResult{code=" + this.code + ", msg='" + this.msg + '\'' + '}';
    }

    private static String generalCodeName(int code) {
        String codeName;
        switch (code) {
            case -2: {
                codeName = "STATUS_INNER_ERROR";
                break;
            }
            case -1: {
                codeName = "STATUS_UNDEFINE";
                break;
            }
            case 0: {
                codeName = "STATUS_OK";
                break;
            }
            case 1: {
                codeName = "STATUS_CONFIG_PARSE_ERROR";
                break;
            }
            case 2: {
                codeName = "STATUS_CONNECTION_WAITTING";
                break;
            }
            case 3: {
                codeName = "STATUS_MODEL_DOWNLOAD_WAITING";
                break;
            }
            case 4: {
                codeName = "STATUS_MODEL_LOAD_FAILED";
                break;
            }
            default: {
                codeName = "UNKNOWN";
            }
        }
        return codeName;
    }
}

